/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.config;

import com.google.common.cache.Cache;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import cool.taomu.box.datasource.DruidDataSourceProvider;
import cool.taomu.box.ioc.ann.Binder;
import cool.taomu.box.ioc.ann.Binders;
import cool.taomu.box.ioc.ann.Mybatis;
import cool.taomu.box.jersery.jetty.JerseyJettyModule;
import cool.taomu.box.jersery.jetty.JsereyJettyServer;
import cool.taomu.box.job.server.controller.abs.AbsPreTaskAndPostTask;
import cool.taomu.box.job.server.controller.impl.PerTaskAndPostTask;
import cool.taomu.box.job.server.provide.CacheProvider;
import cool.taomu.box.job.server.provide.EmailProvider;
import javax.mail.Session;

@Binders(properties = "server.yml", value = { @Binder(bind = JsereyJettyServer.class, to = JsereyJettyServer.class), @Binder(bind = AbsPreTaskAndPostTask.class, to = PerTaskAndPostTask.class), @Binder(bind = Session.class, to = EmailProvider.class) })
@Mybatis(provider = DruidDataSourceProvider.class, scanMapper = { "cool.taomu.box.job.server.dao" })
@SuppressWarnings("all")
public class OAuth2Config extends AbstractModule {
  @Override
  public void configure() {
    this.install(new JerseyJettyModule() {
      @Override
      public void configureModule(final com.google.inject.Binder binder) {
      }
    });
    com.google.inject.Binder _binder = this.binder();
    _binder.<Cache<String, String>>bind(new TypeLiteral<Cache<String, String>>() {
    }).toProvider(CacheProvider.class).asEagerSingleton();
  }
}
