package cool.taomu.box.job.server.controller.abs;

import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.dao.entity.TaskDaoEntity;
import javax.inject.Inject;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
@SuppressWarnings("all")
public abstract class AbsPreTaskAndPostTask {
  @Inject
  private JGitTools jgit;
  
  private static final Logger LOG = LoggerFactory.getLogger(AbsPreTaskAndPostTask.class);
  
  public void preTask(final TaskDaoEntity entity) {
    AbsPreTaskAndPostTask.LOG.info("执行前置任务");
  }
  
  public void postTask(final TaskDaoEntity entity) {
    AbsPreTaskAndPostTask.LOG.info("执行后置任务");
  }
  
  @Pure
  public JGitTools getJgit() {
    return this.jgit;
  }
  
  public void setJgit(final JGitTools jgit) {
    this.jgit = jgit;
  }
}
