package cool.taomu.box.job.server.controller.impl;

import cool.taomu.box.job.server.service.SecurityService;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@SuppressWarnings("all")
public class AuthFilter implements ContainerRequestFilter {
  private static final Logger LOG = LoggerFactory.getLogger(AuthFilter.class);
  
  @Inject
  private SecurityService securityService;
  
  @Inject
  @Named("taomubox.http.auth.value")
  private boolean isAuth;
  
  @Context
  private HttpServletRequest request;
  
  @Override
  public void filter(final ContainerRequestContext requestContext) throws IOException {
    AuthFilter.LOG.info("过滤规则");
    if (this.isAuth) {
      try {
        AuthFilter.LOG.info("用户授权判断");
        final String path = requestContext.getUriInfo().getPath();
        boolean contains = StringUtils.containsAny(path, "index", "task/list", "user/verify", "user/login");
        if (contains) {
          return;
        }
        HttpSession session = this.request.getSession();
        Object value = session.getAttribute("user_login_tag");
        if (((value != null) && value.equals("admin"))) {
          AuthFilter.LOG.info((("获取到正确的值! [" + value) + "]"));
          return;
        }
        String authorizationHeader = requestContext.getHeaderString("Authorization");
        requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).build());
        return;
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception ex = (Exception)_t;
          ex.printStackTrace();
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
  }
}
