/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.controller.impl;

import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.controller.abs.AbsPreTaskAndPostTask;
import cool.taomu.box.job.server.controller.entity.DataProcessingEntity;
import cool.taomu.box.job.server.controller.entity.DataSourceEntity;
import cool.taomu.box.job.server.controller.entity.FileWriteEntity;
import cool.taomu.box.job.server.controller.entity.HtmlTemplateEntity;
import cool.taomu.box.job.server.controller.entity.ResponseEntity;
import cool.taomu.box.job.server.controller.entity.TaskDataResultEntity;
import cool.taomu.box.job.server.controller.entity.TaskResultEntity;
import cool.taomu.box.job.server.controller.inter.ITaskController;
import cool.taomu.box.job.server.dao.entity.DataProcessingDaoEntity;
import cool.taomu.box.job.server.dao.entity.DataSourceDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskResultDaoEntity;
import cool.taomu.box.job.server.script.runtime.DataSource;
import cool.taomu.box.job.server.script.runtime.GTask;
import cool.taomu.box.job.server.service.TaskRunService;
import cool.taomu.box.job.server.service.TaskService;
import cool.taomu.box.job.server.utils.ChineseToPinyin;
import cool.taomu.box.job.server.utils.GetTaskDirectory;
import cool.taomu.box.job.server.utils.MarkdownUtils;
import cool.taomu.box.script.groovy.GroovyDsl;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.inter.ICallback;
import cool.taomu.box.utils.inter.ICallback2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="job")
public class TaskController
implements ITaskController<TaskDaoEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskController.class);
    @Inject
    private TaskService taskService;
    @Inject
    private JGitTools jgit;
    @Inject
    private AbsPreTaskAndPostTask iTask;
    @Inject
    private TaskRunService trunService;
    @Inject
    private GTask task;
    private Response OK = Response.ok().build();

    @POST
    @Path(value="/task/datasource")
    @Consumes(value={"application/json"})
    public Response postTaskDataSource(List<DataSourceEntity> entity) {
        LOG.info(entity.toString());
        DataSourceEntity dsEntity = entity.get(0);
        String dataSourceUuid = UUID.randomUUID().toString();
        boolean _equals = dsEntity.getTaskId().equals("None");
        if (_equals) {
            boolean _greaterThan;
            String pyname = ChineseToPinyin.toPinyin(dsEntity.getTaskName());
            DataSourceDaoEntity dsDaoEntity = new DataSourceDaoEntity();
            String _address = dsEntity.getAddress();
            String _branches = dsEntity.getBranches();
            dsDaoEntity.setAddress(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_address, "(", _branches, ")"})), (CharSequence)""));
            dsDaoEntity.setAuthorizeInfo(dsEntity.getAuthorizeInfo());
            dsDaoEntity.setDataSourceType(dsEntity.getDataSourceType());
            dsDaoEntity.setName(dsEntity.getName());
            dsDaoEntity.setScriptFilePath("");
            dsDaoEntity.setUuid(dataSourceUuid);
            int _saveTaskDataSource = this.taskService.saveTaskDataSource(dsDaoEntity);
            boolean bl = _greaterThan = _saveTaskDataSource > 0;
            if (_greaterThan) {
                TaskDaoEntity createTaskEntity = new TaskDaoEntity();
                createTaskEntity.setTaskName(dsEntity.getTaskName());
                createTaskEntity.setTaskId(UUID.randomUUID().toString());
                createTaskEntity.setDatasourceId(dataSourceUuid);
                createTaskEntity.setTaskVersion(-1);
                createTaskEntity.setTaskDirectory(GetTaskDirectory.getWorkspace(pyname));
                this.taskService.saveTask(createTaskEntity);
                String _taskId = createTaskEntity.getTaskId();
                Pair _mappedTo = Pair.of((Object)"taskId", (Object)_taskId);
                return Response.status((int)201).entity(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo}))).build();
            }
        } else {
            TaskDaoEntity taskEntity = this.taskService.getOneTask(dsEntity.getTaskId());
            if (taskEntity != null && StringUtils.isNotBlank((CharSequence)taskEntity.getDatasourceId())) {
                DataSourceDaoEntity dsDaoEntity_1 = new DataSourceDaoEntity();
                dsDaoEntity_1.setAddress(dsEntity.getAddress());
                dsDaoEntity_1.setAuthorizeInfo(dsEntity.getAuthorizeInfo());
                dsDaoEntity_1.setDataSourceType(dsEntity.getDataSourceType());
                dsDaoEntity_1.setName(dsEntity.getName());
                dsDaoEntity_1.setScriptFilePath("");
                dsDaoEntity_1.setUuid(taskEntity.getDatasourceId());
                this.taskService.updateTaskDataSource(dsDaoEntity_1);
            } else {
                boolean _greaterThan_1;
                DataSourceDaoEntity dsDaoEntity_2 = new DataSourceDaoEntity();
                dsDaoEntity_2.setAddress(dsEntity.getAddress());
                dsDaoEntity_2.setAuthorizeInfo(dsEntity.getAuthorizeInfo());
                dsDaoEntity_2.setDataSourceType(dsEntity.getDataSourceType());
                dsDaoEntity_2.setName(dsEntity.getName());
                dsDaoEntity_2.setScriptFilePath("");
                dsDaoEntity_2.setUuid(dataSourceUuid);
                int _saveTaskDataSource_1 = this.taskService.saveTaskDataSource(dsDaoEntity_2);
                boolean bl = _greaterThan_1 = _saveTaskDataSource_1 > 0;
                if (_greaterThan_1) {
                    taskEntity.setDatasourceId(dataSourceUuid);
                    this.taskService.update(taskEntity);
                }
            }
            String _taskId_1 = taskEntity.getTaskId();
            Pair _mappedTo_1 = Pair.of((Object)"taskId", (Object)_taskId_1);
            return Response.status((int)201).entity(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo_1}))).build();
        }
        return Response.status((int)500).build();
    }

    @POST
    @Path(value="/task/dataprocessing")
    @Consumes(value={"application/json"})
    public Response postTaskDataProcessing(List<DataProcessingEntity> entity) {
        try {
            LOG.info(entity.toString());
            DataProcessingEntity dpEntity = entity.get(0);
            String dprocessingUuid = UUID.randomUUID().toString();
            String pyname = ChineseToPinyin.toPinyin(dpEntity.getTaskName());
            boolean _equals = dpEntity.getTaskId().equals("None");
            if (_equals) {
                boolean _greaterThan;
                DataProcessingDaoEntity datapEntity = new DataProcessingDaoEntity();
                datapEntity.setUuid(dprocessingUuid);
                datapEntity.setName(dpEntity.getName());
                File dir = GetTaskDirectory.getDataprocessing(pyname, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{pyname, "task"})), (CharSequence)"."));
                FileUtils.writeStringToFile((File)dir, (String)dpEntity.getDataProcessingScript(), (String)"UTF-8");
                datapEntity.setScriptFilePath(dir.getAbsolutePath());
                int _saveTaskDataProcessing = this.taskService.saveTaskDataProcessing(datapEntity);
                boolean bl = _greaterThan = _saveTaskDataProcessing > 0;
                if (_greaterThan) {
                    TaskDaoEntity createTaskEntity = new TaskDaoEntity();
                    createTaskEntity.setTaskName(dpEntity.getTaskName());
                    createTaskEntity.setTaskId(UUID.randomUUID().toString());
                    createTaskEntity.setDataProcessingId(dprocessingUuid);
                    createTaskEntity.setTaskVersion(-1);
                    createTaskEntity.setTaskDirectory(GetTaskDirectory.getWorkspace(pyname));
                    this.taskService.saveTask(createTaskEntity);
                    String _taskId = createTaskEntity.getTaskId();
                    Pair _mappedTo = Pair.of((Object)"taskId", (Object)_taskId);
                    return Response.status((int)201).entity(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo}))).build();
                }
            } else {
                TaskDaoEntity taskEntity = this.taskService.getOneTask(dpEntity.getTaskId());
                if (taskEntity != null && StringUtils.isNotBlank((CharSequence)taskEntity.getDataProcessingId())) {
                    DataProcessingDaoEntity datapEntity_1 = new DataProcessingDaoEntity();
                    datapEntity_1.setUuid(dprocessingUuid);
                    datapEntity_1.setName(dpEntity.getName());
                    File dir_1 = GetTaskDirectory.getDataprocessing(pyname, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{pyname, "task"})), (CharSequence)"."));
                    FileUtils.writeStringToFile((File)dir_1, (String)dpEntity.getDataProcessingScript(), (String)"UTF-8");
                    datapEntity_1.setScriptFilePath(dir_1.getAbsolutePath());
                    datapEntity_1.setUuid(taskEntity.getDataProcessingId());
                    this.taskService.updateTaskDataProcessing(datapEntity_1);
                } else {
                    boolean _greaterThan_1;
                    DataProcessingDaoEntity datapEntity_2 = new DataProcessingDaoEntity();
                    datapEntity_2.setUuid(dprocessingUuid);
                    datapEntity_2.setName(dpEntity.getName());
                    File dir_2 = GetTaskDirectory.getDataprocessing(pyname, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{pyname, "task"})), (CharSequence)"."));
                    FileUtils.writeStringToFile((File)dir_2, (String)dpEntity.getDataProcessingScript(), (String)"UTF-8");
                    datapEntity_2.setScriptFilePath(dir_2.getAbsolutePath());
                    int _saveTaskDataProcessing_1 = this.taskService.saveTaskDataProcessing(datapEntity_2);
                    boolean bl = _greaterThan_1 = _saveTaskDataProcessing_1 > 0;
                    if (_greaterThan_1) {
                        taskEntity.setDataProcessingId(dprocessingUuid);
                        this.taskService.update(taskEntity);
                    }
                }
                String _taskId_1 = taskEntity.getTaskId();
                Pair _mappedTo_1 = Pair.of((Object)"taskId", (Object)_taskId_1);
                return Response.status((int)201).entity(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo_1}))).build();
            }
            return Response.status((int)500).build();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @POST
    @Path(value="/task/taskresult")
    @Consumes(value={"application/json"})
    public Response postTaskDataResult(List<TaskDataResultEntity> entity) {
        boolean _greaterThan;
        LOG.info(entity.toString());
        int _size = entity.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            String taskId = entity.get(0).getTaskId();
            String pyTaskName = ChineseToPinyin.toPinyin(entity.get(0).getTaskName());
            TaskDaoEntity taskEntity = this.taskService.getOneTask(taskId);
            ArrayList fileWriteList = new ArrayList();
            if (taskId != null) {
                this.taskService.deleteTaskResultByTaskId(taskId);
                Consumer<TaskDataResultEntity> _function = it -> {
                    boolean _tripleNotEquals;
                    String _taskId = it.getTaskId();
                    boolean bl = _tripleNotEquals = _taskId != null;
                    if (_tripleNotEquals) {
                        TaskResultDaoEntity dsDaoEntity = new TaskResultDaoEntity();
                        dsDaoEntity.setName(it.getName());
                        dsDaoEntity.setTaskId(taskId);
                        dsDaoEntity.setPyName(ChineseToPinyin.toPinyin(it.getName()));
                        dsDaoEntity.setHtmlResultPath("");
                        String _pyName = dsDaoEntity.getPyName();
                        File aneTextFile = GetTaskDirectory.getAnalysisPath(pyTaskName, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pyName, "analyze", "js"})), (CharSequence)"."));
                        String _absolutePath = aneTextFile.getAbsolutePath();
                        String _analyzeAndExtractText = it.getAnalyzeAndExtractText();
                        FileWriteEntity _fileWriteEntity = new FileWriteEntity(_absolutePath, _analyzeAndExtractText);
                        fileWriteList.add(_fileWriteEntity);
                        dsDaoEntity.setAnalyzeAndExtractFilePath(aneTextFile.getAbsolutePath());
                        Perl5Util p5 = new Perl5Util();
                        boolean _match = p5.match("/^#![^?.]*mustache[^?.]*$/", it.getFormatScriptText().trim());
                        if (_match) {
                            it.setFormatScriptText(it.getFormatScriptText().replaceFirst("#![^?.]*mustache", "").trim());
                            String _pyName_1 = dsDaoEntity.getPyName();
                            File formatScriptFile = GetTaskDirectory.getAnalysisPath(pyTaskName, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pyName_1, "format", "mustache"})), (CharSequence)"."));
                            String _absolutePath_1 = formatScriptFile.getAbsolutePath();
                            String _formatScriptText = it.getFormatScriptText();
                            FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(_absolutePath_1, _formatScriptText);
                            fileWriteList.add(_fileWriteEntity_1);
                            dsDaoEntity.setFormatScriptFilePath(formatScriptFile.getAbsolutePath());
                        } else {
                            boolean _match_1 = p5.match("/^#![^?.]*thymeleaf[^?.]*$/", it.getFormatScriptText().trim());
                            if (_match_1) {
                                it.setFormatScriptText(it.getFormatScriptText().replaceFirst("#![^?.]*thymeleaf", "").trim());
                                String _pyName_2 = dsDaoEntity.getPyName();
                                File formatScriptFile_1 = GetTaskDirectory.getAnalysisPath(pyTaskName, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pyName_2, "format", "html"})), (CharSequence)"."));
                                String _absolutePath_2 = formatScriptFile_1.getAbsolutePath();
                                String _formatScriptText_1 = it.getFormatScriptText();
                                FileWriteEntity _fileWriteEntity_2 = new FileWriteEntity(_absolutePath_2, _formatScriptText_1);
                                fileWriteList.add(_fileWriteEntity_2);
                                dsDaoEntity.setFormatScriptFilePath(formatScriptFile_1.getAbsolutePath());
                            }
                        }
                        dsDaoEntity.setUuid(UUID.randomUUID().toString());
                        this.taskService.saveTaskResult(dsDaoEntity);
                    }
                };
                entity.forEach(_function);
                Integer _taskVersion = taskEntity.getTaskVersion();
                int _plus = _taskVersion + 1;
                taskEntity.setTaskVersion(_plus);
                ICallback2 _function_1 = () -> fileWriteList;
                this.taskService.FileWrite(GetTaskDirectory.getWorkspace(pyTaskName), taskEntity.getTaskVersion(), (ICallback2<List<FileWriteEntity>>)_function_1);
                this.taskService.update(taskEntity);
                return Response.status((int)201).build();
            }
        }
        return Response.status((int)500).build();
    }

    @Override
    public Response getTask(String uuid) {
        try {
            LOG.info("\u83b7\u53d6 {} ID\u7684\u4efb\u52a1", (Object)uuid);
            TaskDaoEntity entity = this.taskService.getOneTask(uuid);
            String dsId = entity.getDatasourceId();
            String dpId = entity.getDataProcessingId();
            DataSourceDaoEntity dataSourceEntity = this.taskService.getOneDataSourceByUuid(dsId);
            DataProcessingDaoEntity dataProcessingEntity = this.taskService.getOneDataProcessingByUuid(dpId);
            List<TaskResultDaoEntity> taskResultList = this.taskService.getAllByTaskId(entity.getTaskId());
            RespTaskEntity respTaskEntity = new RespTaskEntity();
            respTaskEntity.taskId = entity.getTaskId();
            respTaskEntity.taskName = entity.getTaskName();
            respTaskEntity.dataSource = dataSourceEntity;
            DataProcessingEntity dping = new DataProcessingEntity();
            String _scriptFilePath = dataProcessingEntity.getScriptFilePath();
            File _file = new File(_scriptFilePath);
            dping.setDataProcessingScript(FileUtils.readFileToString((File)_file, (String)"UTF-8"));
            dping.setName(dataProcessingEntity.getName());
            respTaskEntity.dataProcessing = dping;
            ArrayList tdrEntity = new ArrayList();
            Consumer<TaskResultDaoEntity> _function = it -> {
                try {
                    TaskDataResultEntity temp = new TaskDataResultEntity();
                    String _analyzeAndExtractFilePath = it.getAnalyzeAndExtractFilePath();
                    File _file_1 = new File(_analyzeAndExtractFilePath);
                    temp.setAnalyzeAndExtractText(FileUtils.readFileToString((File)_file_1, (String)"UTF-8"));
                    boolean _endsWith = it.getFormatScriptFilePath().endsWith(".mustache");
                    if (_endsWith) {
                        temp.setFormatScriptText("#! mustache");
                    } else {
                        boolean _endsWith_1 = it.getFormatScriptFilePath().endsWith(".html");
                        if (_endsWith_1) {
                            temp.setFormatScriptText("#! thymeleaf");
                        }
                    }
                    String _formatScriptText = temp.getFormatScriptText();
                    String _formatScriptFilePath = it.getFormatScriptFilePath();
                    File _file_2 = new File(_formatScriptFilePath);
                    String _readFileToString = FileUtils.readFileToString((File)_file_2, (String)"UTF-8");
                    temp.setFormatScriptText(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_formatScriptText, _readFileToString})), (CharSequence)"\n"));
                    temp.setName(it.getName());
                    temp.setPyName(it.getPyName());
                    tdrEntity.add(temp);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            taskResultList.forEach(_function);
            respTaskEntity.taskResultList = tdrEntity;
            ResponseEntity<RespTaskEntity> r = new ResponseEntity<RespTaskEntity>(200).results(respTaskEntity);
            return Response.ok().entity(r).build();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public Response putTask(String uuid, TaskDaoEntity entity) {
        boolean _not;
        LOG.info("\u4fee\u6539 {} ID\u7684\u4efb\u52a1", (Object)uuid);
        TaskDaoEntity taskEntity = this.taskService.getOneTask(uuid);
        String _taskDirectory = taskEntity.getTaskDirectory();
        boolean _exists = new File(_taskDirectory).exists();
        boolean bl = _not = !_exists;
        if (_not) {
            String pyName = ChineseToPinyin.toPinyin(taskEntity.getTaskName());
            this.jgit.setRepository(GetTaskDirectory.getWorkspace(pyName));
            if (StringUtils.isNotBlank((CharSequence)taskEntity.getTaskDirectory()) && !this.jgit.isReprositoryExists()) {
                this.jgit.init();
            }
            String baseDir = GetTaskDirectory.getWorkspace(pyName);
            DataProcessingDaoEntity dpScript = this.taskService.getOneDataProcessingByUuid(taskEntity.getDataProcessingId());
            List<TaskResultDaoEntity> aps = this.taskService.getAllByTaskId(taskEntity.getTaskId());
            Integer _taskVersion = taskEntity.getTaskVersion();
            int _plus = _taskVersion + 1;
            taskEntity.setTaskVersion(_plus);
            Integer _taskVersion_1 = taskEntity.getTaskVersion();
            String version = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{"v", _taskVersion_1})), (CharSequence)"");
            ICallback _function = it -> {
                if (dpScript != null) {
                    String path = FileTools.getSubdirectory((String)baseDir, (String)dpScript.getScriptFilePath(), (String)"/");
                    it.addFilepattern(path.substring(1));
                }
                if (aps != null && ((Object[])Conversions.unwrapArray((Object)aps, Object.class)).length > 0) {
                    Consumer<TaskResultDaoEntity> _function_1 = ait -> {
                        String path_1 = FileTools.getSubdirectory((String)baseDir, (String)ait.getAnalyzeAndExtractFilePath(), (String)"/");
                        it.addFilepattern(path_1.substring(1));
                        path_1 = FileTools.getSubdirectory((String)baseDir, (String)ait.getFormatScriptFilePath(), (String)"/");
                        it.addFilepattern(path_1.substring(1));
                    };
                    aps.forEach(_function_1);
                }
            };
            this.jgit.addAndCommit(version, _function);
            this.taskService.update(taskEntity);
        }
        return Response.status((int)201).build();
    }

    @Override
    public Response deleteTask(String uuid) {
        boolean _not;
        LOG.info("\u5220\u9664\u4efb\u52a1:{}", (Object)uuid);
        TaskDaoEntity oldTask = this.taskService.getOneTask(uuid);
        String _trim = oldTask.getTaskDirectory().trim();
        File dir = new File(_trim);
        LOG.info("\u8981\u5220\u9664\u7684\u76ee\u5f55\u4e3a: {}", (Object)dir.getAbsolutePath());
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)oldTask.getTaskDirectory());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            try {
                boolean _deleteQuietly = FileUtils.deleteQuietly((File)dir);
                if (_deleteQuietly) {
                    boolean _greaterThan;
                    LOG.info("\u5220\u9664\u4efb\u52a1 {} \u76ee\u5f55\u6210\u529f", (Object)dir.getAbsolutePath());
                    this.taskService.deleteTaskResultByTaskId(oldTask.getTaskId());
                    this.taskService.deleteTaskDataProcessing(oldTask.getDataProcessingId());
                    this.taskService.deleteDataSource(oldTask.getDatasourceId());
                    int _deleteOneTask = this.taskService.deleteOneTask(oldTask.getTaskId());
                    boolean bl2 = _greaterThan = _deleteOneTask > 0;
                    if (_greaterThan) {
                        LOG.info("\u5220\u9664\u4efb\u52a1 {} \u6210\u529f", (Object)uuid);
                        return Response.status((int)200).build();
                    }
                    LOG.info("\u5220\u9664\u4efb\u52a1 {} \u5931\u8d25", (Object)uuid);
                    return Response.status((int)402).build();
                }
                LOG.info("\u5220\u9664\u4efb\u52a1 {} \u76ee\u5f55\u5931\u8d25", (Object)dir.getAbsolutePath());
                return Response.status((int)402).build();
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    ex.printStackTrace();
                    return Response.status((int)500).build();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public Response postTask(TaskDaoEntity entity) {
        return this.OK;
    }

    @Override
    public Response runTask(String uuid) {
        try {
            Vector<ByteArrayInputStream> isv = new Vector<ByteArrayInputStream>();
            String coding = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"import cool.taomu.box.job.server.script.runtime.GTask", "public void Task(@DelegatesTo(GTask) Closure<GTask> closure){", "closure.delegate = gtask", "closure()", "}\n\n"})), (CharSequence)"\n");
            byte[] _bytes = coding.getBytes();
            ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
            isv.add(_byteArrayInputStream);
            TaskDaoEntity entity = this.taskService.getOneTask(uuid);
            String dpId = entity.getDataProcessingId();
            DataProcessingDaoEntity dpEntity = this.taskService.getOneDataProcessingByUuid(dpId);
            DataSourceDaoEntity dsEntity = this.taskService.getOneDataSourceByUuid(entity.getDatasourceId());
            String _scriptFilePath = dpEntity.getScriptFilePath();
            File _file = new File(_scriptFilePath);
            String scriptFile = FileUtils.readFileToString((File)_file, (String)"UTF-8");
            byte[] _bytes_1 = StringUtils.defaultString((String)scriptFile, (String)"").getBytes();
            ByteArrayInputStream _byteArrayInputStream_1 = new ByteArrayInputStream(_bytes_1);
            isv.add(_byteArrayInputStream_1);
            String _taskDirectory = entity.getTaskDirectory();
            DataSource _dataSource = new DataSource(dsEntity, _taskDirectory, this.jgit);
            this.task.setDs(_dataSource);
            this.task.setWorkspace(entity.getTaskDirectory());
            HashMap<String, String> _hashMap = new HashMap<String, String>();
            this.task.setEnv(_hashMap);
            Integer _taskVersion = entity.getTaskVersion();
            int _plus = _taskVersion + 1;
            this.task.setVersion(_plus);
            entity.setTaskVersion(this.task.getVersion());
            this.task.setPyName(ChineseToPinyin.toPinyin(entity.getTaskName()));
            Pair _mappedTo = Pair.of((Object)"gtask", (Object)this.task);
            GroovyDsl.dsl(isv, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            this.taskService.update(entity);
            String _pyName = this.task.getPyName();
            File dataResultFile = GetTaskDirectory.getDataresult(this.task.getPyName(), IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pyName, "result", "txt"})), (CharSequence)"."));
            this.trunService.taskResultProcessing(dataResultFile, entity);
            return this.OK;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public Response exitTask(String uuid) {
        TaskDaoEntity entity = this.taskService.getOneTask(uuid);
        LOG.info("\u7ed3\u675f\u4efb\u52a1:{}", (Object)entity.getTaskName());
        entity.setStatus(TaskDaoEntity.TaskStatus.DONE.ordinal());
        this.taskService.update(entity);
        return Response.ok().build();
    }

    @Override
    public Response getTaskType() {
        LOG.info("\u83b7\u53d6\u4efb\u52a1\u7c7b\u578b");
        return Response.ok(this.taskService.getTaskTypeList()).build();
    }

    @Override
    public Response getTaskResult(String uuid) {
        boolean _equals;
        TaskDaoEntity entity = this.taskService.getOneTask(uuid);
        LOG.info("\u83b7\u53d6\u4efb\u52a1{}\u7ed3\u679c", (Object)entity.getTaskName());
        List<TaskResultDaoEntity> all = this.taskService.getAllByTaskId(entity.getTaskId());
        HtmlTemplateEntity results = new HtmlTemplateEntity();
        ArrayList<HtmlTemplateEntity.DataEntity> _arrayList = new ArrayList<HtmlTemplateEntity.DataEntity>();
        results.setData(_arrayList);
        Consumer<TaskResultDaoEntity> _function = it -> {
            try {
                boolean _isNotBlank = StringUtils.isNotBlank((CharSequence)it.getHtmlResultPath());
                if (_isNotBlank) {
                    Perl5Util p5 = new Perl5Util();
                    String _htmlResultPath = it.getHtmlResultPath();
                    File _file = new File(_htmlResultPath);
                    String text = FileUtils.readFileToString((File)_file, (String)"UTF-8");
                    boolean _match = p5.match("/^#![^?.]*markdown[^?.]*$/", text.trim());
                    if (_match) {
                        File file = File.createTempFile("", ".md");
                        text = text.replaceFirst("#![^?.]*markdown", "").trim();
                        FileUtils.writeStringToFile((File)file, (String)text, (String)"UTF-8");
                        HtmlTemplateEntity.DataEntity data = new HtmlTemplateEntity.DataEntity();
                        data.setResultText(MarkdownUtils.getHtml(file));
                        data.setName(it.getName());
                        data.setPyname(it.getPyName());
                        results.getData().add(data);
                        file.delete();
                    } else {
                        HtmlTemplateEntity.DataEntity data_1 = new HtmlTemplateEntity.DataEntity();
                        data_1.setResultText(text);
                        data_1.setName(it.getName());
                        data_1.setPyname(it.getPyName());
                        results.getData().add(data_1);
                    }
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        all.forEach(_function);
        LOG.info("\u83b7\u53d6\u4efb\u52a1{}\u7ed3\u679c {} \u6761", (Object)entity.getTaskName(), (Object)results.getData().size());
        int _status = entity.getStatus();
        int _ordinal = TaskDaoEntity.TaskStatus.SUCCESS.ordinal();
        boolean bl = _equals = _status == _ordinal;
        if (_equals) {
            int _status_1 = entity.getStatus();
            List<HtmlTemplateEntity.DataEntity> _data = results.getData();
            TaskResultEntity<List<HtmlTemplateEntity.DataEntity>> taskResultEntity = new TaskResultEntity<List<HtmlTemplateEntity.DataEntity>>(_status_1, _data).taskId(entity.getTaskId());
            ResponseEntity<TaskResultEntity<List<HtmlTemplateEntity.DataEntity>>> res = new ResponseEntity<TaskResultEntity<List<HtmlTemplateEntity.DataEntity>>>(200).results(taskResultEntity);
            return Response.ok(res.msg("\u83b7\u53d6\u4efb\u52a1\u7ed3\u679c")).build();
        }
        ResponseEntity res_1 = new ResponseEntity(Response.Status.NOT_FOUND);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(res_1).build();
    }

    @Override
    public Response getTaskList() {
        List<TaskDaoEntity> entitys;
        List<TaskDaoEntity> _converted_entitys = entitys = this.taskService.getTaskAll();
        LOG.info("\u83b7\u53d6\u4efb\u52a1\u5217\u8868:{}", (Object)((Object[])Conversions.unwrapArray(_converted_entitys, Object.class)).length);
        return Response.ok(entitys).build();
    }

    @Override
    public Response getTaskStatus(String uuid) {
        int _ordinal_3;
        boolean _equals_3;
        int _ordinal_2;
        boolean _equals_2;
        int _ordinal_1;
        boolean _equals_1;
        int _ordinal;
        boolean _equals;
        TaskDaoEntity entity = this.taskService.getOneTask(uuid);
        int _status = entity.getStatus();
        boolean bl = _equals = _status == (_ordinal = TaskDaoEntity.TaskStatus.SUCCESS.ordinal());
        if (_equals) {
            ResponseEntity res = new ResponseEntity(201);
            return Response.status((int)201).entity(res).build();
        }
        int _status_1 = entity.getStatus();
        boolean bl2 = _equals_1 = _status_1 == (_ordinal_1 = TaskDaoEntity.TaskStatus.IN_PROGRESS.ordinal());
        if (_equals_1) {
            ResponseEntity res_1 = new ResponseEntity(100);
            return Response.status((int)100).entity(res_1).build();
        }
        int _status_2 = entity.getStatus();
        boolean bl3 = _equals_2 = _status_2 == (_ordinal_2 = TaskDaoEntity.TaskStatus.FAIL.ordinal());
        if (_equals_2) {
            ResponseEntity res_2 = new ResponseEntity(500);
            return Response.status((int)500).entity(res_2).build();
        }
        int _status_3 = entity.getStatus();
        boolean bl4 = _equals_3 = _status_3 == (_ordinal_3 = TaskDaoEntity.TaskStatus.WAIT.ordinal());
        if (_equals_3) {
            ResponseEntity res_3 = new ResponseEntity(202);
            return Response.status((int)202).entity(res_3).build();
        }
        ResponseEntity res_4 = new ResponseEntity(100);
        return Response.status((int)100).entity(res_4).build();
    }

    @Override
    public Response getTaskStatusAll() {
        List<TaskDaoEntity> entity = this.taskService.getTaskAll();
        ArrayList list = new ArrayList();
        Consumer<TaskDaoEntity> _function = it -> {
            int _ordinal;
            boolean _equals;
            int _status = it.getStatus();
            boolean bl = _equals = _status == (_ordinal = TaskDaoEntity.TaskStatus.SUCCESS.ordinal());
            if (_equals) {
                ResponseEntity res = new ResponseEntity(201);
                list.add(res);
            } else {
                int _ordinal_1;
                boolean _equals_1;
                int _status_1 = it.getStatus();
                boolean bl2 = _equals_1 = _status_1 == (_ordinal_1 = TaskDaoEntity.TaskStatus.IN_PROGRESS.ordinal());
                if (_equals_1) {
                    ResponseEntity res_1 = new ResponseEntity(100);
                    list.add(res_1);
                } else {
                    int _ordinal_2;
                    boolean _equals_2;
                    int _status_2 = it.getStatus();
                    boolean bl3 = _equals_2 = _status_2 == (_ordinal_2 = TaskDaoEntity.TaskStatus.FAIL.ordinal());
                    if (_equals_2) {
                        ResponseEntity res_2 = new ResponseEntity(500);
                        list.add(res_2);
                    } else {
                        int _ordinal_3;
                        boolean _equals_3;
                        int _status_3 = it.getStatus();
                        boolean bl4 = _equals_3 = _status_3 == (_ordinal_3 = TaskDaoEntity.TaskStatus.WAIT.ordinal());
                        if (_equals_3) {
                            ResponseEntity res_3 = new ResponseEntity(202);
                            list.add(res_3);
                        }
                    }
                }
            }
        };
        entity.forEach(_function);
        return Response.status((int)200).entity(list).build();
    }

    @Accessors
    public static class RespTaskEntity {
        private String taskId;
        private String taskName;
        private DataSourceDaoEntity dataSource;
        private DataProcessingEntity dataProcessing;
        private List<TaskDataResultEntity> taskResultList;

        @Pure
        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Pure
        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        @Pure
        public DataSourceDaoEntity getDataSource() {
            return this.dataSource;
        }

        public void setDataSource(DataSourceDaoEntity dataSource) {
            this.dataSource = dataSource;
        }

        @Pure
        public DataProcessingEntity getDataProcessing() {
            return this.dataProcessing;
        }

        public void setDataProcessing(DataProcessingEntity dataProcessing) {
            this.dataProcessing = dataProcessing;
        }

        @Pure
        public List<TaskDataResultEntity> getTaskResultList() {
            return this.taskResultList;
        }

        public void setTaskResultList(List<TaskDataResultEntity> taskResultList) {
            this.taskResultList = taskResultList;
        }
    }
}

