/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.service;

import com.google.common.base.Objects;
import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.controller.entity.FileWriteEntity;
import cool.taomu.box.job.server.dao.TaskDao;
import cool.taomu.box.job.server.dao.TaskDataProcessingDao;
import cool.taomu.box.job.server.dao.TaskDataSourceDao;
import cool.taomu.box.job.server.dao.TaskResultDao;
import cool.taomu.box.job.server.dao.entity.DataProcessingDaoEntity;
import cool.taomu.box.job.server.dao.entity.DataSourceDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskResultDaoEntity;
import cool.taomu.box.job.server.service.TaskRepositoryService;
import cool.taomu.box.job.server.utils.ChineseToPinyin;
import cool.taomu.box.job.server.utils.GetTaskDirectory;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.inter.ICallback;
import cool.taomu.box.utils.inter.ICallback2;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskService {
    private static final Logger LOG = LoggerFactory.getLogger(TaskService.class);
    @Inject
    private TaskDao dao;
    @Inject
    private TaskDataSourceDao dsDao;
    @Inject
    private TaskDataProcessingDao dpDao;
    @Inject
    private TaskResultDao trDao;
    @Inject
    private TaskRepositoryService trservice;
    @Inject
    private JGitTools jgit;
    private String basePath = System.getProperty("user.dir");

    public DataSourceDaoEntity getOneDataSourceByUuid(String uuid) {
        return this.dsDao.getOneByUuId(uuid);
    }

    public DataProcessingDaoEntity getOneDataProcessingByUuid(String uuid) {
        return this.dpDao.getOneByUuId(uuid);
    }

    public List<TaskResultDaoEntity> getAllByTaskId(String taskId) {
        return this.trDao.getAllByTaskId(taskId);
    }

    public int createWorkspace(TaskDaoEntity taskEntity, List<String> ignores) {
        int _xifexpression = 0;
        boolean _isBlank = StringUtils.isBlank((CharSequence)taskEntity.getTaskDirectory());
        if (_isBlank) {
            int _xblockexpression = 0;
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.basePath, "workspace"})), (CharSequence)File.separator);
            File ws = new File(_join);
            ws.mkdirs();
            String taskNamePinyin = ChineseToPinyin.toPinyin(taskEntity.getTaskName());
            LOG.info("\u4efb\u52a1\u540d:{} \u8f6c\u4e3a\u62fc\u97f3:{}", (Object)taskEntity.getTaskName(), (Object)taskNamePinyin);
            String _absolutePath = ws.getAbsolutePath();
            String _join_1 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath, taskNamePinyin})), (CharSequence)File.separator);
            File cdir = new File(_join_1);
            cdir.mkdirs();
            taskEntity.setTaskDirectory(cdir.getAbsolutePath().replace(ws.getAbsolutePath(), ""));
            String _absolutePath_1 = cdir.getAbsolutePath();
            this.trservice.repositoryPath(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath_1})), (CharSequence)File.separator));
            this.trservice.init(ignores);
            GetTaskDirectory.getDatasource(cdir.getAbsolutePath(), null);
            GetTaskDirectory.getDataprocessing(cdir.getAbsolutePath(), null);
            GetTaskDirectory.getDataresult(cdir.getAbsolutePath(), null);
            _xifexpression = _xblockexpression = this.update(taskEntity);
        }
        return _xifexpression;
    }

    public void FileWrite(String basePath, int vserion, ICallback2<List<FileWriteEntity>> call) {
        if (call != null) {
            int _size_1;
            boolean _greaterThan_1;
            boolean _greaterThan;
            ArrayList subPaths = new ArrayList();
            ArrayList rmPaths = new ArrayList();
            Consumer<FileWriteEntity> _function = it -> {
                try {
                    String spath = it.getPath();
                    FileWriteEntity.OperationType _type = it.getType();
                    boolean _equals = Objects.equal((Object)((Object)_type), (Object)((Object)FileWriteEntity.OperationType.ADD));
                    if (_equals) {
                        LOG.info("\u6dfb\u52a0\u6587\u4ef6:{}", (Object)spath);
                        File _file = new File(spath);
                        FileUtils.writeStringToFile((File)_file, (String)it.getContent().trim(), (String)"UTF-8", (boolean)false);
                        String _trim = basePath.trim();
                        String subPath = FileTools.getSubdirectory((String)IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, File.separator}))), (String)spath, (String)"/");
                        subPaths.add(subPath);
                    } else {
                        FileWriteEntity.OperationType _type_1 = it.getType();
                        boolean _equals_1 = Objects.equal((Object)((Object)_type_1), (Object)((Object)FileWriteEntity.OperationType.RM));
                        if (_equals_1) {
                            LOG.info("\u5220\u9664\u6587\u4ef6:{}", (Object)spath);
                            String _trim_1 = basePath.trim();
                            String subPath_1 = FileTools.getSubdirectory((String)IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim_1, File.separator}))), (String)spath, (String)"/");
                            rmPaths.add(subPath_1);
                        }
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            ((List)call.call()).forEach(_function);
            int _size = subPaths.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                this.jgit.setRepository(basePath);
                this.jgit.setAutoCommit(true);
                LOG.info("\u5411\u672c\u5730\u5e93\u6dfb\u52a0\u6587\u4ef6 {} \u4efd", (Object)subPaths.size());
                String _join = IterableExtensions.join(subPaths, (CharSequence)"\n");
                ICallback _function_1 = it -> {
                    Consumer<String> _function_2 = path -> it.addFilepattern(path);
                    subPaths.forEach(_function_2);
                };
                this.jgit.addAndCommit(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{"add v", vserion, "\n", _join}))), _function_1);
            }
            boolean bl2 = _greaterThan_1 = (_size_1 = rmPaths.size()) > 0;
            if (_greaterThan_1) {
                this.jgit.setRepository(basePath);
                this.jgit.setAutoCommit(true);
                LOG.info("\u5411\u672c\u5730\u5e93\u5220\u9664\u6587\u4ef6 {} \u4efd", (Object)rmPaths.size());
                String _join_1 = IterableExtensions.join(rmPaths, (CharSequence)"\n");
                ICallback _function_2 = it -> {
                    Consumer<String> _function_3 = path -> it.addFilepattern(path);
                    rmPaths.forEach(_function_3);
                };
                this.jgit.rmAndCommit(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{"rm v", vserion, "\n", _join_1}))), _function_2);
            }
        }
    }

    public TaskDaoEntity getOneTask(String taskId) {
        return this.dao.getOneTask(taskId);
    }

    public int deleteOneTask(String taskId) {
        return this.dao.deleteOneTask(taskId);
    }

    public int update(TaskDaoEntity entity) {
        int _xifexpression = 0;
        int _deleteOneTask = this.dao.deleteOneTask(entity.getTaskId());
        boolean _greaterThan = _deleteOneTask > 0;
        _xifexpression = _greaterThan ? this.dao.saveTask(entity) : this.dao.saveTask(entity);
        return _xifexpression;
    }

    public TaskDaoEntity getOneTaskByTaskName(String taskName) {
        return this.dao.getOneTaskByTaskName(taskName);
    }

    public int saveTask(TaskDaoEntity entity) {
        return this.dao.saveTask(entity);
    }

    public int saveTaskDataSource(DataSourceDaoEntity entity) {
        return this.dsDao.saveDataSource(entity);
    }

    public int updateTaskDataSource(DataSourceDaoEntity entity) {
        boolean _greaterThan;
        int _xifexpression = 0;
        int _deleteOneDataSource = this.dsDao.deleteOneDataSource(entity.getUuid());
        boolean bl = _greaterThan = _deleteOneDataSource > 0;
        if (_greaterThan) {
            _xifexpression = this.dsDao.saveDataSource(entity);
        }
        return _xifexpression;
    }

    public List<TaskDaoEntity> getTaskAll() {
        return this.dao.getTaskAll();
    }

    public List<? extends Pair<String, ?>> getTaskTypeList() {
        DataSourceDaoEntity.DataSourceTypeEnum[] _values = DataSourceDaoEntity.DataSourceTypeEnum.values();
        Pair _mappedTo = Pair.of((Object)"data_source_type", (Object)_values);
        Function<DataSourceDaoEntity.DataSourceTypeEnum, Integer> _function = it -> it.ordinal();
        List _collect = ((List)Conversions.doWrapArray((Object)DataSourceDaoEntity.DataSourceTypeEnum.values())).stream().map(_function).collect(Collectors.toList());
        Pair _mappedTo_1 = Pair.of((Object)"data_source_type_value", _collect);
        DataProcessingDaoEntity.DataProcessingTypeEnum[] _values_1 = DataProcessingDaoEntity.DataProcessingTypeEnum.values();
        Pair _mappedTo_2 = Pair.of((Object)"data_processing_type", (Object)_values_1);
        Function<DataProcessingDaoEntity.DataProcessingTypeEnum, Integer> _function_1 = it -> it.ordinal();
        List _collect_1 = ((List)Conversions.doWrapArray((Object)DataProcessingDaoEntity.DataProcessingTypeEnum.values())).stream().map(_function_1).collect(Collectors.toList());
        Pair _mappedTo_3 = Pair.of((Object)"data_processing_type_value", _collect_1);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3}));
    }

    public int saveTaskDataProcessing(DataProcessingDaoEntity entity) {
        return this.dpDao.saveDataSource(entity);
    }

    public int deleteTaskDataProcessing(String uuid) {
        return this.dpDao.deleteOneDataProcessing(uuid);
    }

    public int deleteDataSource(String uuid) {
        return this.dsDao.deleteOneDataSource(uuid);
    }

    public int updateTaskDataProcessing(DataProcessingDaoEntity entity) {
        boolean _greaterThan;
        int _xifexpression = 0;
        int _deleteOneDataProcessing = this.dpDao.deleteOneDataProcessing(entity.getUuid());
        boolean bl = _greaterThan = _deleteOneDataProcessing > 0;
        if (_greaterThan) {
            _xifexpression = this.dpDao.saveDataSource(entity);
        }
        return _xifexpression;
    }

    public int saveTaskResult(TaskResultDaoEntity entity) {
        return this.trDao.saveDataSource(entity);
    }

    public int updateTaskResult(TaskResultDaoEntity entity) {
        int _xifexpression = 0;
        int _deleteOneTaskResultByUuid = this.trDao.deleteOneTaskResultByUuid(entity.getUuid());
        boolean _greaterThan = _deleteOneTaskResultByUuid > 0;
        _xifexpression = _greaterThan ? this.trDao.saveDataSource(entity) : this.trDao.saveDataSource(entity);
        return _xifexpression;
    }

    public int deleteTaskResultByTaskId(String taskId) {
        return this.trDao.deleteOneTaskResultByTaskId(taskId);
    }
}

