/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.dao;

import cool.taomu.box.job.server.dao.entity.UserDaoEntity;
import cool.taomu.box.job.server.dao.provider.UserDaoProvider;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.type.JdbcType;

@Mapper
@SuppressWarnings("all")
public interface UserDao {
  @Result(property = "uuid", column = "uuid", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "userName", column = "user_name", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "passwrod", column = "passwrod", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "clientId", column = "client_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "clientSecret", column = "client_secret", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "authorizeCode", column = "authorize_code", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Select("select * from taomubox_user where user_name = #{userName} and password = #{password}")
  UserDaoEntity getByUserNameAndPasswd(@Param("userName") final String username, @Param("password") final String passwd);
  
  @Result(property = "uuid", column = "uuid", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "userName", column = "user_name", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "passwrod", column = "passwrod", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "clientId", column = "client_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "clientSecret", column = "client_secret", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "authorizeCode", column = "authorize_code", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Select("select * from taomubox_user where user_name = #{userName}")
  UserDaoEntity getByUserName(@Param("userName") final String username);
  
  @Delete("delete from taomubox_user where uuid = uuid")
  int deleteUser(@Param("uuid") final String uuid);
  
  @InsertProvider(type = UserDaoProvider.class, method = "insert")
  int saveUesr(final UserDaoEntity t);
}
