package cool.taomu.box.job.server.utils;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import freemarker.template.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;

@SuppressWarnings("all")
public class TemplateEngineUtils {
  public static StringWriter mustache(final String path, final Map<String, Object> dataModel) {
    try {
      StringWriter writer = new StringWriter();
      DefaultMustacheFactory mf = new DefaultMustacheFactory();
      try (InputStreamReader reader = new Function0<InputStreamReader>() {
        @Override
        public InputStreamReader apply() {
          try {
            FileInputStream _fileInputStream = new FileInputStream(path);
            return new InputStreamReader(_fileInputStream);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        Mustache mustache = mf.compile(reader, path);
        mustache.execute(writer, dataModel).flush();
        return writer;
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static StringWriter thymeleaf(final String path, final Map<String, Object> dataModel) {
    try {
      File _file = new File(path);
      String content = FileUtils.readFileToString(_file, "UTF-8");
      TemplateEngine templateEngine = new TemplateEngine();
      final Context context = new Context();
      final BiConsumer<String, Object> _function = (String k, Object v) -> {
        context.setVariable(k, v);
      };
      dataModel.forEach(_function);
      StringWriter writer = new StringWriter();
      templateEngine.process(content, context, writer);
      return writer;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static StringWriter velocity(final String path, final Map<String, Object> dataModel) {
    int _lastIndexOf = path.lastIndexOf(File.separator);
    int _plus = (_lastIndexOf + 1);
    String subPath = path.substring(0, _plus);
    int _lastIndexOf_1 = path.lastIndexOf(File.separator);
    int _plus_1 = (_lastIndexOf_1 + 1);
    String template = path.substring(_plus_1);
    return TemplateEngineUtils.velocity(subPath, template, dataModel);
  }
  
  public static StringWriter velocity(final String basePath, final String template, final Map<String, Object> dataModel) {
    VelocityEngine ve = new VelocityEngine();
    ve.setProperty(VelocityEngine.FILE_RESOURCE_LOADER_PATH, basePath);
    ve.init();
    final VelocityContext context = new VelocityContext();
    final BiConsumer<String, Object> _function = (String k, Object v) -> {
      context.put(k, v);
    };
    dataModel.forEach(_function);
    StringWriter writer = new StringWriter();
    ve.getTemplate(template, "UTF-8").merge(context, writer);
    return writer;
  }
  
  public static StringWriter freemarker(final String path, final Map<String, Object> dataModel) {
    int _lastIndexOf = path.lastIndexOf(File.separator);
    int _plus = (_lastIndexOf + 1);
    String subPath = path.substring(0, _plus);
    int _lastIndexOf_1 = path.lastIndexOf(File.separator);
    int _plus_1 = (_lastIndexOf_1 + 1);
    String template = path.substring(_plus_1);
    return TemplateEngineUtils.freemarker(subPath, template, dataModel);
  }
  
  public static StringWriter freemarker(final String basePath, final String template, final Map<String, Object> dataModel) {
    try {
      Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);
      File _file = new File(basePath);
      cfg.setDirectoryForTemplateLoading(_file);
      StringWriter writer = new StringWriter();
      cfg.getTemplate(template).process(dataModel, writer);
      return writer;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static String markdown(final String path) {
    return MarkdownUtils.getHtml(path);
  }
}
