/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.controller;

import cool.taomu.box.job.server.dao.TaskDao;
import cool.taomu.box.job.server.service.UserService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.glassfish.jersey.server.mvc.ErrorTemplate;
import org.glassfish.jersey.server.mvc.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("job")
@SuppressWarnings("all")
public class IndexController {
  private static final Logger LOG = LoggerFactory.getLogger(IndexController.class);
  
  @Inject
  private TaskDao dao;
  
  @Inject
  private UserService uservice;
  
  @Inject
  @Named("taomubox.title")
  private String title;
  
  @Inject
  @Named("taomubox.http.pathSpec")
  private String pathSpec = "";
  
  @Inject
  @Named("taomubox.http.auth.value")
  private boolean isAuth;
  
  @GET
  @Path("/{page}")
  @ErrorTemplate(name = "/error.ftl")
  @Template(name = "/main.ftl")
  @Produces(MediaType.TEXT_HTML)
  public Map<String, String> page(@PathParam("page") final String page, @Context final HttpServletRequest request) {
    try {
      HashMap<String, String> pcmap = new HashMap<String, String>();
      pcmap.put("title", this.title);
      pcmap.put("pathSpec", this.pathSpec.trim());
      HttpSession session = request.getSession(false);
      StringBuffer buf = new StringBuffer("<script>");
      buf.append("var pathSpec=\'");
      buf.append(this.pathSpec);
      buf.append("\';</script>");
      if ((((session != null) && (session.getAttribute("user_login_tag") != null)) || (!this.isAuth))) {
        File _file = new File((("./template/" + page) + ".html"));
        buf.append(FileUtils.readFileToString(_file, "UTF-8"));
        pcmap.put("content", buf.toString());
        File _file_1 = new File("./template/menu.html");
        pcmap.put("menu", FileUtils.readFileToString(_file_1, "UTF-8"));
        File _file_2 = new File("./template/navbar.html");
        pcmap.put("navbar", FileUtils.readFileToString(_file_2, "UTF-8"));
      } else {
        File _file_3 = new File("./template/login.html");
        buf.append(FileUtils.readFileToString(_file_3, "UTF-8"));
        pcmap.put("content", buf.toString());
        pcmap.put("menu", "");
        File _file_4 = new File("./template/navbar_login.html");
        pcmap.put("navbar", FileUtils.readFileToString(_file_4, "UTF-8"));
      }
      return pcmap;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
