/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.dao;

import cool.taomu.box.job.server.dao.entity.TaskDaoEntity;
import cool.taomu.box.job.server.dao.provider.TaskDaoProvider;
import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.type.JdbcType;

@Mapper
@SuppressWarnings("all")
public interface TaskDao {
  @Result(property = "taskId", column = "task_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskName", column = "task_name", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "schedule", column = "schedule", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "isScheduledTask", column = "is_schedule_task", javaType = Boolean.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "parameter", column = "parameter", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "shellPath", column = "shell_path", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskVersion", column = "task_version", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "htmlTemplate", column = "html_template", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "runTimestamp", column = "run_timestamp", javaType = Long.class, jdbcType = JdbcType.TIMESTAMP)
  @Result(property = "taskAddTimestmap", column = "TASK_CREATE_TIMESTMAP", javaType = Long.class, jdbcType = JdbcType.BIGINT)
  @Result(property = "clientId", column = "client_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "type", column = "type", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "shellType", column = "shell_type", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "status", column = "STATUS", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "taskDirectory", column = "TASK_DIRECTORY", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "extendColumn", column = "EXTEND_COLUMN", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "exceptionInfo", column = "exception_info", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "datasourceId", column = "DATASOURCE_ID", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "dataProcessingId", column = "DATA_PROCESSING_ID", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "dependentTaskId", column = "dependent_task_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Select("select * from TAOMUBOX_JOB_TASK where task_id=#{taskId}")
  TaskDaoEntity getOneTask(@Param("taskId") final String taskId);
  
  @Result(property = "datasourceId", column = "DATASOURCE_ID", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "dataProcessingId", column = "DATA_PROCESSING_ID", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "dependentTaskId", column = "dependent_task_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskId", column = "task_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "exceptionInfo", column = "exception_info", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskName", column = "task_name", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "schedule", column = "schedule", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "isScheduledTask", column = "is_schedule_task", javaType = Boolean.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "parameter", column = "parameter", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "shellPath", column = "shell_Path", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskVersion", column = "task_version", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "htmlTemplate", column = "html_template", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskDirectory", column = "TASK_DIRECTORY", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "extendColumn", column = "EXTEND_COLUMN", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "runTimestamp", column = "run_timestamp", javaType = Long.class, jdbcType = JdbcType.TIMESTAMP)
  @Result(property = "taskAddTimestmap", column = "TASK_CREATE_TIMESTMAP", javaType = Long.class, jdbcType = JdbcType.BIGINT)
  @Result(property = "clientId", column = "client_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "type", column = "type", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "shellType", column = "shell_type", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "status", column = "STATUS", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Select("select * from TAOMUBOX_JOB_TASK where task_name=#{taskName}")
  TaskDaoEntity getOneTaskByTaskName(@Param("taskName") final String taskName);
  
  @Result(property = "datasourceId", column = "DATASOURCE_ID", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "dataProcessingId", column = "DATA_PROCESSING_ID", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "dependentTaskId", column = "dependent_task_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskId", column = "task_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskName", column = "task_name", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "schedule", column = "schedule", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "isScheduledTask", column = "is_schedule_task", javaType = Boolean.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "parameter", column = "parameter", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "shellPath", column = "shell_path", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskVersion", column = "task_version", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "htmlTemplate", column = "html_template", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "extendColumn", column = "EXTEND_COLUMN", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "taskDirectory", column = "TASK_DIRECTORY", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "runTimestamp", column = "run_timestamp", javaType = Long.class, jdbcType = JdbcType.TIMESTAMP)
  @Result(property = "taskAddTimestmap", column = "TASK_CREATE_TIMESTMAP", javaType = Long.class, jdbcType = JdbcType.BIGINT)
  @Result(property = "clientId", column = "client_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "type", column = "type", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "shellType", column = "shell_type", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "status", column = "STATUS", javaType = Integer.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "exceptionInfo", column = "exception_info", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Select("select * from TAOMUBOX_JOB_TASK")
  List<TaskDaoEntity> getTaskAll();
  
  @InsertProvider(type = TaskDaoProvider.class, method = "insert")
  int saveTask(@Param("t") final TaskDaoEntity entity);
  
  @Delete("delete from TAOMUBOX_JOB_TASK where task_id=#{taskId}")
  int deleteOneTask(@Param("taskId") final String taskId);
}
