package cool.taomu.box.job.server.script.runtime;

import cool.taomu.box.job.server.controller.entity.FileWriteEntity;
import cool.taomu.box.job.server.utils.CsvUtils;
import cool.taomu.box.job.server.utils.GetTaskDirectory;
import cool.taomu.box.job.server.utils.ShellExecute;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
@SuppressWarnings("all")
public class GTask {
  @Accessors
  public static class Analyze {
    private CsvUtils csv;
    
    private List<String> content;
    
    public void csv(final String... args) {
      this.csv.append(args);
    }
    
    public void analyzer(final Closure closure) {
      closure.call(this.content);
    }
    
    @Pure
    public CsvUtils getCsv() {
      return this.csv;
    }
    
    public void setCsv(final CsvUtils csv) {
      this.csv = csv;
    }
    
    @Pure
    public List<String> getContent() {
      return this.content;
    }
    
    public void setContent(final List<String> content) {
      this.content = content;
    }
  }
  
  private static final Logger LOG = LoggerFactory.getLogger(GTask.class);
  
  private DataSource ds;
  
  private String workspace;
  
  private String pyName;
  
  private int version;
  
  private Map<String, String> env;
  
  private List<FileWriteEntity> fileWriteList;
  
  public void datasource(@DelegatesTo(DataSource.class) final Closure<DataSource> closure) {
    closure.setDelegate(this.ds);
    closure.call();
  }
  
  private File shellFile;
  
  public void analyze(final String name, final Closure<GTask.Analyze> closure) {
    try {
      if ((this.shellFile != null)) {
        List<String> content = FileUtils.readLines(this.shellFile, "UTF-8");
        final File file = GetTaskDirectory.getDataresult(this.pyName, IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(this.pyName, name, "result", "csv")), "."));
        GTask.Analyze anlyzeObj = new GTask.Analyze();
        anlyzeObj.content = content;
        String _absolutePath = file.getAbsolutePath();
        CsvUtils _csvUtils = new CsvUtils(_absolutePath);
        anlyzeObj.csv = _csvUtils;
        closure.setDelegate(anlyzeObj);
        closure.call();
        anlyzeObj.csv.write();
        String _absolutePath_1 = file.getAbsolutePath();
        FileWriteEntity _fileWriteEntity = new FileWriteEntity(_absolutePath_1, "");
        this.fileWriteList.add(_fileWriteEntity);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public File shell(final String content) {
    try {
      File _xblockexpression = null;
      {
        GTask.LOG.info(content.trim());
        final File file = GetTaskDirectory.getDataresult(this.pyName, IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(this.pyName, "result", "txt")), "."));
        String fname = UUID.randomUUID().toString().replace("-", "");
        final StringBuffer buf = new StringBuffer();
        if ((!SystemUtils.IS_OS_WINDOWS)) {
          File sh = File.createTempFile(fname, ".sh");
          GTask.LOG.info("执行脚本路径:{}", sh.getAbsolutePath());
          FileUtils.writeStringToFile(sh, content.trim(), "UTF-8");
          FileUtils.writeStringToFile(file, "", "UTF-8");
          final ShellExecute.ShellCallback _function = (String it) -> {
            GTask.LOG.info("chmod +x : {}", it);
          };
          ShellExecute.start("Linux", _function, this.env, "chmod", "+x", sh.getAbsolutePath());
          final ShellExecute.ShellCallback _function_1 = (String it) -> {
            buf.append(it);
          };
          ShellExecute.start("Linux", _function_1, this.env, "/bin/bash", "-c", sh.getAbsolutePath());
          sh.delete();
        } else {
          File sh_1 = File.createTempFile(fname, ".bat");
          GTask.LOG.info("执行脚本路径:{}", sh_1.getAbsolutePath());
          FileUtils.writeStringToFile(sh_1, content.trim(), "UTF-8");
          FileUtils.writeStringToFile(file, "", "UTF-8");
          final ShellExecute.ShellCallback _function_2 = (String it) -> {
            buf.append(it);
          };
          ShellExecute.start("Windows", _function_2, this.env, sh_1.getAbsolutePath());
        }
        String _absolutePath = file.getAbsolutePath();
        String _string = buf.toString();
        FileWriteEntity _fileWriteEntity = new FileWriteEntity(_absolutePath, _string);
        this.fileWriteList.add(_fileWriteEntity);
        _xblockexpression = this.shellFile = file;
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Pure
  public DataSource getDs() {
    return this.ds;
  }
  
  public void setDs(final DataSource ds) {
    this.ds = ds;
  }
  
  @Pure
  public String getWorkspace() {
    return this.workspace;
  }
  
  public void setWorkspace(final String workspace) {
    this.workspace = workspace;
  }
  
  @Pure
  public String getPyName() {
    return this.pyName;
  }
  
  public void setPyName(final String pyName) {
    this.pyName = pyName;
  }
  
  @Pure
  public int getVersion() {
    return this.version;
  }
  
  public void setVersion(final int version) {
    this.version = version;
  }
  
  @Pure
  public Map<String, String> getEnv() {
    return this.env;
  }
  
  public void setEnv(final Map<String, String> env) {
    this.env = env;
  }
  
  @Pure
  public List<FileWriteEntity> getFileWriteList() {
    return this.fileWriteList;
  }
  
  public void setFileWriteList(final List<FileWriteEntity> fileWriteList) {
    this.fileWriteList = fileWriteList;
  }
  
  @Pure
  public File getShellFile() {
    return this.shellFile;
  }
  
  public void setShellFile(final File shellFile) {
    this.shellFile = shellFile;
  }
}
