package cool.taomu.box.job.server.service;

import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * HJdC5cbxMznaXm9w
 */
@SuppressWarnings("all")
public class EmailService {
  private static final Logger LOG = LoggerFactory.getLogger(EmailService.class);
  
  @Inject
  private Session session;
  
  @Inject
  @Named("taomubox.mail.from")
  private String from;
  
  public void sendEmail(final String to, final String subject, final String body) {
    try {
      try {
        Message message = new MimeMessage(this.session);
        InternetAddress _internetAddress = new InternetAddress(this.from);
        message.setFrom(_internetAddress);
        message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
        message.setSubject(subject);
        message.setText(body);
        Transport.send(message);
      } catch (final Throwable _t) {
        if (_t instanceof MessagingException) {
          final MessagingException e = (MessagingException)_t;
          EmailService.LOG.info(e.getMessage());
          e.printStackTrace();
          throw e;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
