/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class MarkdownUtils {
  public static String getHtml(final String path) {
    File file = new File(path);
    boolean _exists = file.exists();
    if (_exists) {
      return MarkdownUtils.getHtml(file);
    }
    return "";
  }
  
  public static String getHtml(final File file) {
    try {
      List<Extension> extensions = Arrays.<Extension>asList(TablesExtension.create());
      Parser parser = Parser.builder().extensions(extensions).build();
      HtmlRenderer renderer = HtmlRenderer.builder().extensions(extensions).build();
      FileInputStream _fileInputStream = new FileInputStream(file);
      InputStreamReader _inputStreamReader = new InputStreamReader(_fileInputStream);
      Node document = parser.parseReader(_inputStreamReader);
      return renderer.render(document);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
