package cool.taomu.box.job.server.controller;

import com.google.common.cache.Cache;
import cool.taomu.box.job.server.controller.entity.LoginEntity;
import cool.taomu.box.job.server.dao.entity.UserDaoEntity;
import cool.taomu.box.job.server.service.EmailService;
import cool.taomu.box.job.server.service.UserService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("/user")
@SuppressWarnings("all")
public class LoginController {
  private static final Logger LOG = LoggerFactory.getLogger(LoginController.class);
  
  @Inject
  @Named("taomubox.title")
  private String title;
  
  @Inject
  @Named("taomubox.http.pathSpec")
  private String pathSpec = "";
  
  @Inject
  @Named("taomubox.http.auth.admin")
  private String adminUserName;
  
  @Inject
  @Named("taomubox.http.auth.email")
  private String adminEmail;
  
  @Inject
  private UserService uservice;
  
  @Inject
  private EmailService emailService;
  
  @Inject
  private Cache<String, String> codeCache;
  
  @GET
  @Path("/verify/code/{userName}")
  @Produces(MediaType.APPLICATION_JSON)
  public Response sendCode(@PathParam("userName") final String userName) {
    LoginController.LOG.info("向用户邮箱发送验证码");
    boolean _containsKey = this.codeCache.asMap().containsKey(userName);
    if (_containsKey) {
      return Response.status(201).build();
    }
    UserDaoEntity entity = this.uservice.getUserEntityByUsername(userName);
    if (((entity != null) || this.adminUserName.equals(userName.trim()))) {
      this.codeCache.put(userName, "1233ab");
      try {
        LoginController.LOG.info("向用户邮箱发送动态密码");
        boolean _equals = userName.equals(this.adminUserName);
        if (_equals) {
          this.emailService.sendEmail(this.adminEmail, "动态密码", this.codeCache.getIfPresent(userName));
        } else {
          this.emailService.sendEmail(entity.getEmail(), "动态密码", this.codeCache.getIfPresent(userName));
        }
        return Response.ok().build();
      } catch (final Throwable _t) {
        if (_t instanceof MessagingException) {
          final MessagingException e = (MessagingException)_t;
          this.codeCache.invalidate(userName);
          e.printStackTrace();
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    this.codeCache.invalidate(userName);
    return Response.status(500).build();
  }
  
  @POST
  @Path("/login")
  @Produces(MediaType.APPLICATION_JSON)
  @Consumes(MediaType.APPLICATION_JSON)
  public Response login(@Context final HttpServletRequest request, final LoginEntity entity) {
    if (((entity.getUserName().trim().equals(this.adminUserName) && (this.codeCache.getIfPresent(entity.getUserName()) != null)) && 
      this.codeCache.getIfPresent(entity.getUserName()).equals(entity.getVerifyCode()))) {
      HttpSession session = request.getSession(true);
      session.setAttribute("user_login_tag", entity.getUserName().trim());
      UserDaoEntity _userEntityByUsername = this.uservice.getUserEntityByUsername(entity.getUserName().trim());
      boolean _tripleEquals = (_userEntityByUsername == null);
      if (_tripleEquals) {
        UserDaoEntity uentity = new UserDaoEntity();
        uentity.setUserName(entity.getUserName().trim());
        int _saveUser = this.uservice.saveUser(uentity);
        boolean _greaterThan = (_saveUser > 0);
        if (_greaterThan) {
          uentity = this.uservice.getUserEntityByUsername(uentity.getUserName());
          this.codeCache.invalidate(entity.getUserName());
          return Response.status(304).entity(uentity).build();
        }
      }
    }
    UserDaoEntity uentity_1 = this.uservice.getUserEntityByUsername(entity.getUserName().trim());
    if ((((uentity_1 != null) && (this.codeCache.getIfPresent(entity.getUserName()) != null)) && this.codeCache.getIfPresent(entity.getUserName()).equals(entity.getVerifyCode()))) {
      this.codeCache.invalidate(entity.getUserName());
      return Response.status(304).entity(uentity_1).build();
    }
    return Response.status(Response.Status.UNAUTHORIZED).build();
  }
  
  @GET
  @Path("/logout")
  @Produces(MediaType.APPLICATION_JSON)
  @Consumes(MediaType.APPLICATION_JSON)
  public Response logout(@Context final HttpServletRequest request) {
    HttpSession session = request.getSession();
    Object _attribute = session.getAttribute("user_login_tag");
    String userName = ((String) _attribute);
    LoginController.LOG.info("用户{}退出了", userName);
    session.removeAttribute("user_login_tag");
    UserDaoEntity userEntity = this.uservice.getUserEntityByUsername(userName.trim());
    if ((userEntity != null)) {
      return Response.ok().build();
    }
    return Response.ok().build();
  }
}
