package cool.taomu.box.job.server.controller.inter;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;

@SuppressWarnings("all")
public interface ITaskController {
  @GET
  @Path("/task/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  String getTask(@PathParam("taskId") final String uuid);
  
  @PUT
  @Path("/task/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  String putTask(@PathParam("taskId") final String uuid);
  
  @DELETE
  @Path("/task/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  String deleteTask(@PathParam("taskId") final String uuid);
  
  @POST
  @Path("/task")
  @Consumes(MediaType.APPLICATION_JSON)
  String postTask();
  
  @GET
  @Path("/task/run/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  String runTask();
}
