package cool.taomu.box.job.server.controller;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.glassfish.jersey.server.mvc.ErrorTemplate;
import org.glassfish.jersey.server.mvc.Template;

@Path("job")
@SuppressWarnings("all")
public class IndexController {
  @GET
  @Path("/{page}")
  @ErrorTemplate(name = "/error.ftl")
  @Template(name = "/main.ftl")
  @Produces(MediaType.TEXT_HTML)
  public Map<String, String> page(@PathParam("page") final String page) {
    try {
      Perl5Util p5 = new Perl5Util();
      File _file = new File((("./template/" + page) + ".html"));
      String hpage = FileUtils.readFileToString(_file, "UTF-8");
      HashMap<String, String> pcmap = new HashMap<String, String>();
      PatternMatcherInput input = new PatternMatcherInput(hpage);
      boolean _match = p5.match("/<!-- PAGE CONTENT BEGINS -->([^?.]*)<!-- PAGE CONTENT ENDS -->/", input);
      if (_match) {
        String pageContent = p5.group(1);
        pcmap.put("content", pageContent);
      }
      boolean _containsKey = pcmap.containsKey("content");
      boolean _not = (!_containsKey);
      if (_not) {
        File _file_1 = new File("./template/index.html");
        pcmap.put("content", FileUtils.readFileToString(_file_1, "UTF-8"));
      }
      boolean _containsKey_1 = pcmap.containsKey("menu");
      boolean _not_1 = (!_containsKey_1);
      if (_not_1) {
        File _file_2 = new File("./template/menu.html");
        pcmap.put("menu", FileUtils.readFileToString(_file_2, "UTF-8"));
      }
      return pcmap;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
