package cool.taomu.box.job.server.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class TaskEntity {
  public enum TaskType {
    SHELL,
    
    TOPIC,
    
    REMOTE,
    
    SSH;
  }
  
  public enum TaskStatus {
    FAIL,
    
    SUCCESS,
    
    WAIT,
    
    READY;
  }
  
  public enum ShellType {
    JavaScript,
    
    Groovy,
    
    Bsh,
    
    Shell,
    
    BatchFile,
    
    Jython,
    
    JRuby,
    
    Python,
    
    Ruby,
    
    NodeJS;
  }
  
  private TaskEntity.TaskType type;
  
  private TaskEntity.ShellType shellType;
  
  private String taskId;
  
  private String clientId;
  
  private String taskName;
  
  private TaskEntity.TaskStatus status;
  
  private long runTimestamp;
  
  private long taskAddTimestmap;
  
  private String schedule;
  
  private boolean isScheduledTask;
  
  private String parameter;
  
  private String shell;
  
  private String results;
  
  private String htmlTemplate;
  
  @Pure
  public TaskEntity.TaskType getType() {
    return this.type;
  }
  
  public void setType(final TaskEntity.TaskType type) {
    this.type = type;
  }
  
  @Pure
  public TaskEntity.ShellType getShellType() {
    return this.shellType;
  }
  
  public void setShellType(final TaskEntity.ShellType shellType) {
    this.shellType = shellType;
  }
  
  @Pure
  public String getTaskId() {
    return this.taskId;
  }
  
  public void setTaskId(final String taskId) {
    this.taskId = taskId;
  }
  
  @Pure
  public String getClientId() {
    return this.clientId;
  }
  
  public void setClientId(final String clientId) {
    this.clientId = clientId;
  }
  
  @Pure
  public String getTaskName() {
    return this.taskName;
  }
  
  public void setTaskName(final String taskName) {
    this.taskName = taskName;
  }
  
  @Pure
  public TaskEntity.TaskStatus getStatus() {
    return this.status;
  }
  
  public void setStatus(final TaskEntity.TaskStatus status) {
    this.status = status;
  }
  
  @Pure
  public long getRunTimestamp() {
    return this.runTimestamp;
  }
  
  public void setRunTimestamp(final long runTimestamp) {
    this.runTimestamp = runTimestamp;
  }
  
  @Pure
  public long getTaskAddTimestmap() {
    return this.taskAddTimestmap;
  }
  
  public void setTaskAddTimestmap(final long taskAddTimestmap) {
    this.taskAddTimestmap = taskAddTimestmap;
  }
  
  @Pure
  public String getSchedule() {
    return this.schedule;
  }
  
  public void setSchedule(final String schedule) {
    this.schedule = schedule;
  }
  
  @Pure
  public boolean isScheduledTask() {
    return this.isScheduledTask;
  }
  
  public void setIsScheduledTask(final boolean isScheduledTask) {
    this.isScheduledTask = isScheduledTask;
  }
  
  @Pure
  public String getParameter() {
    return this.parameter;
  }
  
  public void setParameter(final String parameter) {
    this.parameter = parameter;
  }
  
  @Pure
  public String getShell() {
    return this.shell;
  }
  
  public void setShell(final String shell) {
    this.shell = shell;
  }
  
  @Pure
  public String getResults() {
    return this.results;
  }
  
  public void setResults(final String results) {
    this.results = results;
  }
  
  @Pure
  public String getHtmlTemplate() {
    return this.htmlTemplate;
  }
  
  public void setHtmlTemplate(final String htmlTemplate) {
    this.htmlTemplate = htmlTemplate;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("type", this.type);
    b.add("shellType", this.shellType);
    b.add("taskId", this.taskId);
    b.add("clientId", this.clientId);
    b.add("taskName", this.taskName);
    b.add("status", this.status);
    b.add("runTimestamp", this.runTimestamp);
    b.add("taskAddTimestmap", this.taskAddTimestmap);
    b.add("schedule", this.schedule);
    b.add("isScheduledTask", this.isScheduledTask);
    b.add("parameter", this.parameter);
    b.add("shell", this.shell);
    b.add("results", this.results);
    b.add("htmlTemplate", this.htmlTemplate);
    return b.toString();
  }
}
