package cool.taomu.box.mybatis.plus;

import cool.taomu.box.mybatis.plus.ann.Column;
import cool.taomu.box.mybatis.plus.ann.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class MybatisPlusBaseProvider {
  public String selectBase(final Class<?> zlass) {
    return this.selectBase(zlass, null);
  }
  
  public String selectBase(final Class<?> zlass, final String where) {
    final StringBuffer sqlBuffer = new StringBuffer("select ");
    Field[] fields = zlass.getDeclaredFields();
    final ArrayList<String> columns = CollectionLiterals.<String>newArrayList();
    final Field[] _converted_fields = (Field[])fields;
    final Consumer<Field> _function = (Field it) -> {
      it.setAccessible(true);
      Column column = it.<Column>getAnnotation(Column.class);
      if ((column != null)) {
        columns.add(column.value());
      }
    };
    ((List<Field>)Conversions.doWrapArray(_converted_fields)).forEach(_function);
    final Predicate<String> _function_1 = (String it) -> {
      return ((it == null) || it.equals(""));
    };
    columns.removeIf(_function_1);
    sqlBuffer.append(IterableExtensions.join(columns, ","));
    sqlBuffer.append(" from ");
    Table _annotation = zlass.<Table>getAnnotation(Table.class);
    boolean _tripleNotEquals = (_annotation != null);
    if (_tripleNotEquals) {
      sqlBuffer.append(zlass.<Table>getAnnotation(Table.class).value());
    }
    sqlBuffer.append(" ");
    boolean _isNotBlank = StringUtils.isNotBlank(where);
    if (_isNotBlank) {
      sqlBuffer.append(where);
    }
    return sqlBuffer.toString();
  }
  
  public String deleteBase(final Class<?> zlass) {
    return this.deleteBase(zlass, null);
  }
  
  public String deleteBase(final Class<?> zlass, final String where) {
    final StringBuffer sqlBuffer = new StringBuffer("delete from ");
    Table _annotation = zlass.<Table>getAnnotation(Table.class);
    boolean _tripleNotEquals = (_annotation != null);
    if (_tripleNotEquals) {
      sqlBuffer.append(zlass.<Table>getAnnotation(Table.class).value());
    }
    sqlBuffer.append(" ");
    boolean _isNotBlank = StringUtils.isNotBlank(where);
    if (_isNotBlank) {
      sqlBuffer.append(where);
    }
    return sqlBuffer.toString();
  }
  
  public String insertBase(final Class<?> zlass, final Object obj) {
    final StringBuffer sqlBuffer = new StringBuffer(" INSERT INTO  ");
    Table _annotation = zlass.<Table>getAnnotation(Table.class);
    boolean _tripleNotEquals = (_annotation != null);
    if (_tripleNotEquals) {
      sqlBuffer.append(zlass.<Table>getAnnotation(Table.class).value());
    }
    sqlBuffer.append(" (");
    Field[] fields = zlass.getDeclaredFields();
    final ArrayList<String> columns = CollectionLiterals.<String>newArrayList();
    final ArrayList<Object> values = CollectionLiterals.<Object>newArrayList();
    final Field[] _converted_fields = (Field[])fields;
    final Consumer<Field> _function = (Field it) -> {
      try {
        it.setAccessible(true);
        Column column = it.<Column>getAnnotation(Column.class);
        if ((column != null)) {
          columns.add(column.value());
          boolean _isEnum = it.getType().isEnum();
          if (_isEnum) {
            values.add(Integer.valueOf(Enum.class.cast(it.get(obj)).ordinal()));
          } else {
            if ((it.getType().equals(String.class) || column.type().equals(String.class))) {
              String _name = it.getName();
              values.add(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("\'${t.", _name, "}\'")), ""));
            } else {
              String _name_1 = it.getName();
              values.add(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("${t.", _name_1, "}")), ""));
            }
          }
        }
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    };
    ((List<Field>)Conversions.doWrapArray(_converted_fields)).forEach(_function);
    final Predicate<String> _function_1 = (String it) -> {
      return ((it == null) || it.equals(""));
    };
    columns.removeIf(_function_1);
    final Predicate<Object> _function_2 = (Object it) -> {
      return ((it == null) || it.equals(""));
    };
    values.removeIf(_function_2);
    sqlBuffer.append(IterableExtensions.join(columns, ","));
    sqlBuffer.append(") ");
    sqlBuffer.append("VALUES (");
    sqlBuffer.append(IterableExtensions.join(values, ","));
    sqlBuffer.append(") ");
    return sqlBuffer.toString();
  }
}
