package cool.taomu.box.netty.mqtt.dao;

import cool.taomu.box.netty.mqtt.dao.entity.MqttUserEntity;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
@SuppressWarnings("all")
public interface MqttUserDao {
  int insert(final MqttUserEntity entity);
  
  @Update("update mqtt_user set online=#{online} where clientid=#{clientId}")
  int updateByClientId(@Param("online") final String online, @Param("clientId") final String id);
  
  @Select("select * from mqtt_user")
  List<MqttUserEntity> selectAll();
  
  @Select("select * from mqtt_user where clientid=#{clientId}")
  MqttUserEntity selectByClientId(@Param("clientId") final String clientId);
}
