package cool.taomu.box.netty.mqtt.utils;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cool.taomu.box.netty.mqtt.entity.ClientSessionEntity;
import cool.taomu.box.netty.mqtt.inter.ICache;

@SuppressWarnings("all")
public class ClientSessionEntityCache implements ICache<Optional<ClientSessionEntity>> {
  private static final Cache<String, Optional<ClientSessionEntity>> cache = CacheBuilder.newBuilder().<String, Optional<ClientSessionEntity>>build();
  
  @Override
  public Optional<ClientSessionEntity> get(final String key) {
    return ClientSessionEntityCache.cache.getIfPresent(key);
  }
  
  @Override
  public void put(final String key, final Optional<ClientSessionEntity> value) {
    ClientSessionEntityCache.cache.put(key, value);
  }
}
