/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.mqtt.impl;

import cool.taomu.box.netty.mqtt.entity.MessageEntity;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.service.MqttPublishService;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.ReferenceCountUtil;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttPublish
implements INettyMqtt {
    private static final Logger LOG = LoggerFactory.getLogger(MqttPublish.class);
    @Inject
    private MqttPublishService publish;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        block14: {
            try {
                if (!(mqttMessage instanceof MqttPublishMessage)) {
                    return;
                }
                MqttPublishMessage publishMessage = (MqttPublishMessage)mqttMessage;
                MessageEntity message = new MessageEntity();
                message.setSenderId(MqttUtils.getClientId(ctx.channel()));
                String _senderId = message.getSenderId();
                String _plus = "\u6267\u884c\u4e86MQTT Publish \u547d\u4ee4 : " + _senderId;
                LOG.info(_plus);
                MqttQoS qos = publishMessage.fixedHeader().qosLevel();
                message.setQos(qos.ordinal());
                message.setTopic(publishMessage.variableHeader().topicName());
                message.setPayload(((MqttPublishMessage)mqttMessage).payload());
                message.setType(mqttMessage.fixedHeader().messageType().value());
                message.setDup(publishMessage.fixedHeader().isDup());
                message.setRetain(publishMessage.fixedHeader().isRetain());
                message.setMsgId(publishMessage.variableHeader().packetId());
                message.setSenderChannel(ctx.channel());
                if (qos != null) {
                    switch (qos) {
                        case EXACTLY_ONCE: 
                        case AT_MOST_ONCE: {
                            LOG.info(String.format("Qos0 and Qos2 message,clientId=%s", message.getSenderId()));
                            this.publish.message(message);
                            break;
                        }
                        case AT_LEAST_ONCE: {
                            LOG.info(String.format("Qos1 message,clientId=%s", message.getSenderId()));
                            this.publish.message(message);
                            MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.PUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
                            MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from((int)message.getMsgId());
                            MqttPubAckMessage _mqttPubAckMessage = new MqttPubAckMessage(header, varHeader);
                            ctx.writeAndFlush((Object)_mqttPubAckMessage);
                            break;
                        }
                        default: {
                            LOG.info(String.format("Wrong mqtt message,clientId=%s", message.getSenderId()));
                            break;
                        }
                    }
                } else {
                    LOG.info(String.format("Wrong mqtt message,clientId=%s", message.getSenderId()));
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    LOG.debug("\u6267\u884c\u4e86MQTT Publish \u547d\u4ee4\u51fa\u9519\u4e86 : ", (Throwable)ex);
                    break block14;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                ReferenceCountUtil.release((Object)mqttMessage.payload());
            }
        }
    }
}

