/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.mqtt.impl;

import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import cool.taomu.box.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import java.util.HashSet;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.lmdbjava.Dbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttPubAck
implements INettyMqtt {
    private static final Logger LOG = LoggerFactory.getLogger(MqttPubAck.class);
    @Inject
    private IStorage cache;
    @Inject
    private ISerializationUtils isu;

    @Override
    public void request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        String clientId = MqttUtils.getClientId(ctx.channel());
        if (clientId == null) {
            clientId = MqttUtils.getClientId(ctx.channel());
        }
        MqttPubAckMessage puback = (MqttPubAckMessage)mqttMessage;
        int msgId = puback.variableHeader().messageId();
        HashSet ackMsg = null;
        try {
            Object _deserialize = this.isu.deserialize(this.cache.get("mqtt-message", clientId));
            ackMsg = (HashSet)_deserialize;
        }
        catch (Throwable _t) {
            if (_t instanceof Dbi.KeyNotFoundException) {
                HashSet _hashSet;
                ackMsg = _hashSet = new HashSet();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        ackMsg.add(msgId);
        this.cache.put("mqtt-message", clientId, this.isu.serialize(ackMsg));
        LOG.info("\u6267\u884c\u4e86MQTT PubAck \u547d\u4ee4 clientId : {} messageId : {}", (Object)clientId, (Object)msgId);
    }
}

