/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.dao;

import cool.taomu.box.netty.mqtt.dao.entity.MqttUserEntity;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
@SuppressWarnings("all")
public interface MqttUserDao {
  int insert(final MqttUserEntity entity);
  
  @Update("update mqtt_user set online=#{online} where clientid=#{clientId}")
  int updateByClientId(@Param("online") final String online, @Param("clientId") final String id);
  
  @Select("select * from mqtt_user")
  List<MqttUserEntity> selectAll();
  
  @Select("select * from mqtt_user where clientid=#{clientId}")
  MqttUserEntity selectByClientId(@Param("clientId") final String clientId);
}
