/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.impl;

import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import cool.taomu.box.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import java.util.HashSet;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.lmdbjava.Dbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class MqttPubAck implements INettyMqtt {
  private static final Logger LOG = LoggerFactory.getLogger(MqttPubAck.class);
  
  @Inject
  private IStorage cache;
  
  @Inject
  private ISerializationUtils isu;
  
  @Override
  public void request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    String clientId = MqttUtils.getClientId(ctx.channel());
    if ((clientId == null)) {
      clientId = MqttUtils.getClientId(ctx.channel());
    }
    MqttPubAckMessage puback = ((MqttPubAckMessage) mqttMessage);
    int msgId = puback.variableHeader().messageId();
    HashSet<Integer> ackMsg = null;
    try {
      Object _deserialize = this.isu.<Object>deserialize(this.cache.get("mqtt-message", clientId));
      ackMsg = ((HashSet<Integer>) _deserialize);
    } catch (final Throwable _t) {
      if (_t instanceof Dbi.KeyNotFoundException) {
        HashSet<Integer> _hashSet = new HashSet<Integer>();
        ackMsg = _hashSet;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    ackMsg.add(Integer.valueOf(msgId));
    this.cache.put("mqtt-message", clientId, this.isu.serialize(ackMsg));
    MqttPubAck.LOG.info("执行了MQTT PubAck 命令 clientId : {} messageId : {}", clientId, Integer.valueOf(msgId));
  }
}
