/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.service;

import com.google.common.base.Optional;
import com.google.inject.name.Named;
import cool.taomu.box.netty.mqtt.dao.MqttUserDao;
import cool.taomu.box.netty.mqtt.dao.entity.MqttUserEntity;
import cool.taomu.box.netty.mqtt.entity.ClientSessionEntity;
import cool.taomu.box.netty.mqtt.inter.ICache;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import io.netty.channel.ChannelHandlerContext;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class MqttSessionService {
  private static final Logger LOG = LoggerFactory.getLogger(MqttSessionService.class);
  
  @Inject
  @Named("ClientSessionEntity")
  private ICache<Optional<ClientSessionEntity>> cache;
  
  @Inject
  private ISerializationUtils isu;
  
  @Inject
  private MqttUserDao userDao;
  
  public byte[] toBytes(final ClientSessionEntity s) {
    return this.isu.serialize(s);
  }
  
  public boolean create(final String clientId, final ChannelHandlerContext ctx, final boolean cleanSession) {
    MqttSessionService.LOG.info("记录用户session：{}", clientId);
    ClientSessionEntity mqttSession = new ClientSessionEntity();
    boolean sessionPresent = false;
    mqttSession.setClientId(clientId);
    mqttSession.setCtx(ctx);
    mqttSession.setCleanStatus(cleanSession);
    if ((!cleanSession)) {
      sessionPresent = true;
    }
    this.cache.put(clientId, Optional.<ClientSessionEntity>of(mqttSession));
    MqttUserEntity entity = this.userDao.selectByClientId(clientId);
    this.userDao.updateByClientId("1", entity.getClientId());
    return sessionPresent;
  }
  
  public void clean(final String clientId) {
    MqttUserEntity entity = this.userDao.selectByClientId(clientId);
    this.userDao.updateByClientId("0", entity.getClientId());
  }
}
