/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.mqtt;

import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import cool.taomu.box.ioc.guice.TaomuGuiceModule;
import cool.taomu.box.netty.mqtt.NettMqttModule;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyMqttHandler
extends ChannelInboundHandlerAdapter {
    private final Logger LOG = LoggerFactory.getLogger(NettyMqttHandler.class);
    private Module module = new TaomuGuiceModule().build(new Class[]{NettMqttModule.class});

    public void channelRead(ChannelHandlerContext ctx, Object obj) {
        MqttMessage mqttMessage = (MqttMessage)obj;
        if (mqttMessage != null && mqttMessage.decoderResult().isSuccess()) {
            MqttMessageType messageType = mqttMessage.fixedHeader().messageType();
            this.LOG.debug("\u6536\u5230\u8bf7\u6c42\u7c7b\u578b\uff1a{}", (Object)messageType.name());
            INettyMqtt instance = (INettyMqtt)Guice.createInjector((Module[])new Module[]{this.module}).getInstance(Key.get(INettyMqtt.class, (Annotation)Names.named((String)messageType.name())));
            instance.request(ctx, mqttMessage);
        } else {
            ctx.close();
        }
    }
}

