/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.mqtt.impl;

import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.entity.MessageEntity;
import cool.taomu.box.netty.mqtt.entity.TopicEntity;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.service.MqttPublishService;
import cool.taomu.box.netty.mqtt.service.MqttSubscribeService;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSubscribe
implements INettyMqtt {
    private static final Logger LOG = LoggerFactory.getLogger(MqttSubscribe.class);
    @Inject
    private ISerializationUtils isu;
    @Inject
    private MqttPublishService publish;
    @Inject
    private MqttSubscribeService subscribeService;

    public byte[] toBytes(TopicEntity s) {
        return this.isu.serialize(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        block11: {
            try {
                if (!(mqttMessage instanceof MqttSubscribeMessage)) {
                    return;
                }
                String clientId = MqttUtils.getClientId(ctx.channel());
                if (clientId == null) {
                    Thread.sleep(100L);
                    clientId = MqttUtils.getClientId(ctx.channel());
                }
                LOG.info("\u6267\u884c\u4e86MQTT Subscribe \u547d\u4ee4 : " + clientId);
                try {
                    ArrayList<TopicEntity> validTopicList;
                    MqttSubscribeMessage subscribeMessage = (MqttSubscribeMessage)mqttMessage;
                    int messageId = subscribeMessage.variableHeader().messageId();
                    ArrayList<TopicEntity> arrayList = validTopicList = this.registerTopics(ctx, subscribeMessage.payload().topicSubscriptions());
                    synchronized (arrayList) {
                        if (validTopicList == null || validTopicList.size() == 0) {
                            LOG.info(String.format("Valid all subscribe topic failure,messageId:%s", messageId));
                            return;
                        }
                        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
                        MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from((int)messageId);
                        List<Integer> _topicQos = this.getTopicQos(validTopicList);
                        MqttSubAckPayload _mqttSubAckPayload = new MqttSubAckPayload(_topicQos);
                        MqttSubAckMessage _mqttSubAckMessage = new MqttSubAckMessage(header, varHeader, _mqttSubAckPayload);
                        ctx.writeAndFlush((Object)_mqttSubAckMessage);
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception ex = (Exception)_t;
                        LOG.debug("subscribe requst exception:", (Throwable)ex);
                        break block11;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public List<Integer> getTopicQos(List<TopicEntity> topics) {
        int _size = topics.size();
        ArrayList<Integer> qoss = new ArrayList<Integer>(_size);
        for (TopicEntity topic : topics) {
            qoss.add(topic.getQos());
        }
        return qoss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<TopicEntity> registerTopics(ChannelHandlerContext ctx, List<MqttTopicSubscription> topics) {
        ChannelHandlerContext channelHandlerContext = ctx;
        synchronized (channelHandlerContext) {
            String clientId = MqttUtils.getClientId(ctx.channel());
            ArrayList<TopicEntity> topicList = new ArrayList<TopicEntity>();
            for (MqttTopicSubscription subscription : topics) {
                String _picFilter = subscription.topicFilter();
                int _value = subscription.qualityOfService().value();
                TopicEntity topic = new TopicEntity(_picFilter, _value);
                topic.setClientId(clientId);
                LOG.info("\u8ba2\u9605Topic {} \u7684\u7528\u6237{}", (Object)topic.getName(), (Object)clientId);
                Perl5Util p5 = new Perl5Util();
                boolean _match = p5.match("/^[A-Za-z0-9]+([\\/A-Za-z0-9_]*|\\/\\+||\\/\\#)$/", topic.getName());
                if (_match) {
                    this.subscribeService.add(topic);
                    HashSet retain = new HashSet();
                    if (!IterableExtensions.isNullOrEmpty(retain) && retain.size() > 0) {
                        Consumer<MessageEntity> _function = it -> this.publish.publishMessage(topic, (MessageEntity)it);
                        retain.forEach(_function);
                    }
                }
                topicList.add(topic);
            }
            return topicList;
        }
    }
}

