/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.mqtt.service;

import com.google.common.base.Optional;
import com.google.inject.name.Named;
import cool.taomu.box.netty.mqtt.dao.MqttUserDao;
import cool.taomu.box.netty.mqtt.dao.entity.MqttUserEntity;
import cool.taomu.box.netty.mqtt.entity.ClientSessionEntity;
import cool.taomu.box.netty.mqtt.inter.ICache;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import io.netty.channel.ChannelHandlerContext;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSessionService {
    private static final Logger LOG = LoggerFactory.getLogger(MqttSessionService.class);
    @Inject
    @Named(value="ClientSessionEntity")
    private ICache<Optional<ClientSessionEntity>> cache;
    @Inject
    private ISerializationUtils isu;
    @Inject
    private MqttUserDao userDao;

    public byte[] toBytes(ClientSessionEntity s) {
        return this.isu.serialize(s);
    }

    public boolean create(String clientId, ChannelHandlerContext ctx, boolean cleanSession) {
        LOG.info("\u8bb0\u5f55\u7528\u6237session\uff1a{}", (Object)clientId);
        ClientSessionEntity mqttSession = new ClientSessionEntity();
        boolean sessionPresent = false;
        mqttSession.setClientId(clientId);
        mqttSession.setCtx(ctx);
        mqttSession.setCleanStatus(cleanSession);
        if (!cleanSession) {
            sessionPresent = true;
        }
        this.cache.put(clientId, (Optional<ClientSessionEntity>)Optional.of((Object)mqttSession));
        MqttUserEntity entity = this.userDao.selectByClientId(clientId);
        this.userDao.updateByClientId("1", entity.getClientId());
        return sessionPresent;
    }

    public void clean(String clientId) {
        MqttUserEntity entity = this.userDao.selectByClientId(clientId);
        this.userDao.updateByClientId("0", entity.getClientId());
    }
}

