/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.dao;

import cool.taomu.box.netty.mqtt.dao.entity.MqttSubscribeEntity;
import java.util.List;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
@SuppressWarnings("all")
public interface MqttSubscribeDao {
  @Insert("insert into mqtt_subscribe(uuid,clientid,topic,qos) values(#{uuid},#{clientid},#{topic},#{qos})")
  int insert(@Param("uuid") final String uuid, @Param("clientid") final String clientid, @Param("topic") final String topic, @Param("qos") final int qos);
  
  @Select("select * from mqtt_subscribe")
  List<MqttSubscribeEntity> selectAll();
  
  @Select("select * from mqtt_subscribe where topic=#{topicName}")
  List<MqttSubscribeEntity> selectByTopic(final String topicName);
  
  @Select("select * from mqtt_subscribe where clientid=#{clientId}")
  List<MqttSubscribeEntity> selectByClientId(final String clientId);
}
