/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.utils;

import cool.taomu.box.netty.mqtt.dao.entity.MqttUserEntity;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.service.MqttConnectService;
import io.netty.channel.Channel;

@SuppressWarnings("all")
public class CheckConnect {
  public static boolean version(final int ver) {
    switch (ver) {
      case 3:
      case 4:
        return true;
      default:
        return false;
    }
  }
  
  public static boolean clientId(final Channel channel, final String clientId, final MqttConnectService service) {
    MqttUserEntity entity = service.getUserInfo(clientId);
    if ((((entity != null) && entity.getClientId().equals(clientId)) && entity.getOnLine().equals("0"))) {
      MqttUtils.setClientId(channel, clientId);
      return true;
    }
    return false;
  }
  
  public static boolean authorized(final String addr, final String clientId) {
    return true;
  }
  
  public static boolean userAuth(final String clientId, final String userName, final byte[] password) {
    return true;
  }
}
