/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.dao;

import cool.taomu.box.netty.mqtt.dao.entity.MqttSessionEntity;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
@SuppressWarnings("all")
public interface MqttSessionDao {
  @Insert("insert into mqtt_session(clientid,session) values(#{clientId},#{session})")
  int insert(@Param("clientId") final String clientId, @Param("session") final String session);
  
  @Delete("delete from mqtt_session where clientid=#{clientId}")
  int delete(@Param("clientId") final String clientid);
  
  @Select("select * from mqtt_session where clientid=#{clientId}")
  MqttSessionEntity selectOne(@Param("clientId") final String clientid);
}
