/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.impl;

import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.service.MqttSessionService;
import cool.taomu.box.netty.mqtt.service.MqttWillService;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class MqttDisconnect implements INettyMqtt {
  private static final Logger LOG = LoggerFactory.getLogger(MqttDisconnect.class);
  
  @Inject
  private MqttWillService will;
  
  @Inject
  private MqttSessionService session;
  
  @Override
  public void request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    MqttDisconnect.LOG.info("执行了MQTT Disconnect 命令");
    String clientId = MqttUtils.getClientId(ctx.channel());
    this.will.push(clientId);
    this.session.clean(clientId);
    ctx.close();
  }
}
