/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.mqtt.impl;

import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.service.MqttConnectService;
import cool.taomu.box.netty.mqtt.service.MqttSessionService;
import cool.taomu.box.netty.mqtt.service.MqttWillService;
import cool.taomu.box.netty.mqtt.utils.CheckConnect;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.timeout.IdleStateHandler;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttConnect
implements INettyMqtt {
    private static final Logger LOG = LoggerFactory.getLogger(MqttConnect.class);
    private MqttConnectReturnCode code;
    private boolean sessionPresent;
    @Inject
    private MqttSessionService session;
    @Inject
    private MqttWillService will;
    @Inject
    private MqttConnectService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        block16: {
            if (!(mqttMessage instanceof MqttConnectMessage)) {
                return;
            }
            LOG.info("\u6267\u884c Connect \u64cd\u4f5c");
            boolean sessionPresent = false;
            try {
                boolean _not;
                MqttConnectMessage connect = (MqttConnectMessage)mqttMessage;
                int version = connect.variableHeader().version();
                LOG.info("mqtt version:{}", (Object)version);
                boolean isCleanSession = connect.variableHeader().isCleanSession();
                String clientId = connect.payload().clientIdentifier();
                String uname = connect.payload().userName();
                byte[] passwd = connect.payload().passwordInBytes();
                int heartbeatSec = connect.variableHeader().keepAliveTimeSeconds();
                LOG.info("clientId:{},cleanSession:{}", (Object)clientId, (Object)isCleanSession);
                boolean _version = CheckConnect.version(version);
                boolean bl = _not = !_version;
                if (_not) {
                    this.code = MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION;
                    this.sessionPresent = sessionPresent;
                } else {
                    boolean _not_1;
                    boolean _clientId = CheckConnect.clientId(ctx.channel(), clientId, this.service);
                    boolean bl2 = _not_1 = !_clientId;
                    if (_not_1) {
                        this.code = MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED;
                        this.sessionPresent = sessionPresent;
                    } else {
                        boolean _not_2;
                        boolean _authorized = CheckConnect.authorized(MqttUtils.getRemoteAddr(ctx.channel()), clientId);
                        boolean bl3 = _not_2 = !_authorized;
                        if (_not_2) {
                            this.code = MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED;
                            this.sessionPresent = sessionPresent;
                        } else {
                            boolean _not_3;
                            boolean _userAuth = CheckConnect.userAuth(clientId, uname, passwd);
                            boolean bl4 = _not_3 = !_userAuth;
                            if (_not_3) {
                                this.code = MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD;
                                this.sessionPresent = sessionPresent;
                            } else {
                                boolean _not_4;
                                boolean _keepAlive = this.keepAlive(clientId, ctx, heartbeatSec);
                                boolean bl5 = _not_4 = !_keepAlive;
                                if (_not_4) {
                                    String failure = String.format("set heartbeat failure clientId:%s,heartbeatSec:%d", clientId, heartbeatSec);
                                    throw new Exception(failure);
                                }
                                this.code = MqttConnectReturnCode.CONNECTION_ACCEPTED;
                                sessionPresent = this.session.create(clientId, ctx, isCleanSession);
                                this.will.store(connect, clientId);
                            }
                        }
                    }
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    LOG.info("\u670d\u52a1\u4e0d\u53ef\u7528 :", (Throwable)ex);
                    this.code = MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE;
                    this.sessionPresent = sessionPresent;
                    break block16;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                this.response(ctx, mqttMessage);
            }
        }
    }

    public ChannelFuture response(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        ChannelFuture _xblockexpression = null;
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.CONNACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttConnAckVariableHeader varHeader = new MqttConnAckVariableHeader(this.code, this.sessionPresent);
        MqttConnAckMessage _mqttConnAckMessage = new MqttConnAckMessage(header, varHeader);
        _xblockexpression = ctx.writeAndFlush((Object)_mqttConnAckMessage);
        return _xblockexpression;
    }

    public boolean keepAlive(String clientId, ChannelHandlerContext ctx, int heatbeatSec) {
        LOG.info("\u8bbe\u7f6ekeep alive");
        int keepAlive = (int)((float)heatbeatSec * 1.5f);
        boolean _contains = ctx.pipeline().names().contains("idleStateHandler");
        if (_contains) {
            ctx.pipeline().remove("idleStateHandler");
        }
        ChannelPipeline _pipeline = ctx.pipeline();
        IdleStateHandler _idleStateHandler = new IdleStateHandler(keepAlive, 0, 0);
        _pipeline.addFirst("idleStateHandler", (ChannelHandler)_idleStateHandler);
        return true;
    }
}

