/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.impl;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.entity.TopicEntity;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import cool.taomu.box.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.HashSet;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class MqttUnSubscribe implements INettyMqtt {
  private static final Logger LOG = LoggerFactory.getLogger(MqttUnSubscribe.class);
  
  @Inject
  private IStorage cache;
  
  @Inject
  private ISerializationUtils isu;
  
  @Override
  public void request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    MqttUnsubscribeMessage message = ((MqttUnsubscribeMessage) mqttMessage);
    int messageId = message.variableHeader().messageId();
    final String clientId = MqttUtils.getClientId(ctx.channel());
    Object _deserialize = this.isu.<Object>deserialize(this.cache.get("mqtt-subscribe", "subscribe"));
    HashSet<TopicEntity> subscribes = ((HashSet<TopicEntity>) _deserialize);
    final Function1<TopicEntity, Boolean> _function = (TopicEntity it) -> {
      boolean _xifexpression = false;
      String _clientId = it.getClientId();
      boolean _equals = Objects.equal(_clientId, clientId);
      if (_equals) {
        _xifexpression = false;
      } else {
        _xifexpression = true;
      }
      return Boolean.valueOf(_xifexpression);
    };
    Iterable<TopicEntity> nsubscribes = IterableExtensions.<TopicEntity>filter(subscribes, _function);
    subscribes.clear();
    Iterables.<TopicEntity>addAll(subscribes, nsubscribes);
    this.cache.put("mqtt-subscribe", "subscribe", this.isu.serialize(subscribes));
    MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
    MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from(messageId);
    MqttUnsubAckMessage _mqttUnsubAckMessage = new MqttUnsubAckMessage(header, varHeader);
    ctx.writeAndFlush(_mqttUnsubAckMessage);
  }
}
