/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.service;

import cool.taomu.box.netty.mqtt.dao.MqttSubscribeDao;
import cool.taomu.box.netty.mqtt.dao.entity.MqttSubscribeEntity;
import cool.taomu.box.netty.mqtt.entity.TopicEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class MqttSubscribeService {
  @Inject
  private MqttSubscribeDao dao;
  
  public void add(final TopicEntity entity) {
    String uuid = UUID.randomUUID().toString();
    this.dao.insert(uuid, entity.getClientId(), entity.getName(), entity.getQos());
  }
  
  public ArrayList<TopicEntity> get() {
    List<MqttSubscribeEntity> list = this.dao.selectAll();
    final ArrayList<TopicEntity> topicEntitys = new ArrayList<TopicEntity>();
    final Consumer<MqttSubscribeEntity> _function = (MqttSubscribeEntity it) -> {
      String _topic = it.getTopic();
      TopicEntity entity = new TopicEntity(_topic);
      entity.setClientId(it.getClientId());
      entity.setQos(it.getQos());
      topicEntitys.add(entity);
    };
    IterableExtensions.<MqttSubscribeEntity>filterNull(list).forEach(_function);
    return topicEntitys;
  }
}
