/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.mqtt.impl;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import cool.taomu.box.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttUnSubscribe
implements INettyMqtt {
    private static final Logger LOG = LoggerFactory.getLogger(MqttUnSubscribe.class);
    @Inject
    private IStorage cache;
    @Inject
    private ISerializationUtils isu;

    @Override
    public void request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        MqttUnsubscribeMessage message = (MqttUnsubscribeMessage)mqttMessage;
        int messageId = message.variableHeader().messageId();
        String clientId = MqttUtils.getClientId(ctx.channel());
        Object _deserialize = this.isu.deserialize(this.cache.get("mqtt-subscribe", "subscribe"));
        HashSet subscribes = (HashSet)_deserialize;
        Functions.Function1 _function = it -> {
            boolean _xifexpression = false;
            String _clientId = it.getClientId();
            boolean _equals = Objects.equal((Object)_clientId, (Object)clientId);
            _xifexpression = !_equals;
            return _xifexpression;
        };
        Iterable nsubscribes = IterableExtensions.filter((Iterable)subscribes, (Functions.Function1)_function);
        subscribes.clear();
        Iterables.addAll((Collection)subscribes, (Iterable)nsubscribes);
        this.cache.put("mqtt-subscribe", "subscribe", this.isu.serialize(subscribes));
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from((int)messageId);
        MqttUnsubAckMessage _mqttUnsubAckMessage = new MqttUnsubAckMessage(header, varHeader);
        ctx.writeAndFlush((Object)_mqttUnsubAckMessage);
    }
}

