/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.impl;

import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.entity.MessageEntity;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import cool.taomu.box.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.Collections;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class MqttPubRec implements INettyMqtt {
  private static final Logger LOG = LoggerFactory.getLogger(MqttPubRec.class);
  
  @Inject
  private IStorage cache;
  
  @Inject
  private ISerializationUtils isu;
  
  public byte[] toBytes(final MessageEntity s) {
    return this.isu.serialize(s);
  }
  
  public Object toObject(final byte[] b) {
    return this.isu.<Object>deserialize(b);
  }
  
  @Override
  public void request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    String clientId = MqttUtils.getClientId(ctx.channel());
    MqttPubRec.LOG.info(("执行了MQTT PubRec 命令 : " + clientId));
    Object _variableHeader = mqttMessage.variableHeader();
    MqttMessageIdVariableHeader idVariableHeader = ((MqttMessageIdVariableHeader) _variableHeader);
    int msgId = idVariableHeader.messageId();
    byte[] qos2 = this.cache.get("mqtt-qos2-message", IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(clientId, Integer.valueOf(msgId))), "#"));
    if ((qos2 != null)) {
      Object _object = this.toObject(qos2);
      MessageEntity msg = ((MessageEntity) _object);
      MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.PUBREC, false, MqttQoS.AT_MOST_ONCE, false, 0);
      MqttMessageIdVariableHeader _from = MqttMessageIdVariableHeader.from(msgId);
      MqttMessage _mqttMessage = new MqttMessage(header, _from);
      msg.getSenderChannel().writeAndFlush(_mqttMessage);
      this.cache.remove("mqtt-qos2-message", IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(clientId, Integer.valueOf(msgId))), "#"));
      msg.setSenderChannel(ctx.channel());
      String senderId = msg.getSenderId();
      msg.setSenderId(clientId);
      this.cache.put("mqtt-qos2-message", IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(senderId, Integer.valueOf(msgId))), "#"), this.toBytes(msg));
    }
  }
}
