/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.netty.mqtt.entity;

import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@EqualsHashCode
@SuppressWarnings("all")
public class ClientSessionEntity implements Serializable {
  private String clientId;
  
  private boolean cleanStatus;
  
  private transient ChannelHandlerContext ctx;
  
  private transient AtomicInteger messageIdCounter = new AtomicInteger(1);
  
  public int generateMessageId() {
    int messageId = this.messageIdCounter.getAndIncrement();
    messageId = Math.abs((messageId % 0xFFFF));
    if ((messageId == 0)) {
      return this.generateMessageId();
    }
    return messageId;
  }
  
  @Pure
  public String getClientId() {
    return this.clientId;
  }
  
  public void setClientId(final String clientId) {
    this.clientId = clientId;
  }
  
  @Pure
  public boolean isCleanStatus() {
    return this.cleanStatus;
  }
  
  public void setCleanStatus(final boolean cleanStatus) {
    this.cleanStatus = cleanStatus;
  }
  
  @Pure
  public ChannelHandlerContext getCtx() {
    return this.ctx;
  }
  
  public void setCtx(final ChannelHandlerContext ctx) {
    this.ctx = ctx;
  }
  
  @Pure
  public AtomicInteger getMessageIdCounter() {
    return this.messageIdCounter;
  }
  
  public void setMessageIdCounter(final AtomicInteger messageIdCounter) {
    this.messageIdCounter = messageIdCounter;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("clientId", this.clientId);
    b.add("cleanStatus", this.cleanStatus);
    return b.toString();
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ClientSessionEntity other = (ClientSessionEntity) obj;
    if (this.clientId == null) {
      if (other.clientId != null)
        return false;
    } else if (!this.clientId.equals(other.clientId))
      return false;
    if (other.cleanStatus != this.cleanStatus)
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.clientId== null) ? 0 : this.clientId.hashCode());
    return prime * result + (this.cleanStatus ? 1231 : 1237);
  }
}
