/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.mqtt.impl;

import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.entity.MessageEntity;
import cool.taomu.box.netty.mqtt.extend.MqttUtils;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import cool.taomu.box.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.Collections;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttPubComp
implements INettyMqtt {
    private static final Logger LOG = LoggerFactory.getLogger(MqttPubComp.class);
    @Inject
    private IStorage cache;
    @Inject
    private ISerializationUtils isu;

    public byte[] toBytes(MessageEntity s) {
        return this.isu.serialize(s);
    }

    public Object toObject(byte[] b) {
        return this.isu.deserialize(b);
    }

    @Override
    public void request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        String clientId = MqttUtils.getClientId(ctx.channel());
        LOG.info("\u6267\u884c\u4e86MQTT PubComp \u547d\u4ee4 : " + clientId);
        int msgId = MqttUtils.getMessageId(mqttMessage);
        byte[] qos2 = this.cache.get("mqtt-qos2-message", IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{clientId, msgId})), (CharSequence)"#"));
        if (qos2 != null) {
            Object _object = this.toObject(qos2);
            MessageEntity msg = (MessageEntity)_object;
            this.cache.remove("mqtt-qos2-message", IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{clientId, msgId})), (CharSequence)"#"));
            MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 0);
            MqttMessageIdVariableHeader _from = MqttMessageIdVariableHeader.from((int)msgId);
            MqttMessage _mqttMessage = new MqttMessage(header, (Object)_from);
            msg.getSenderChannel().writeAndFlush((Object)_mqttMessage);
        }
    }
}

