/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.mqtt.service;

import com.google.inject.Inject;
import cool.taomu.box.netty.mqtt.dao.MqttRetainMessageDao;
import cool.taomu.box.netty.mqtt.dao.entity.MqttRetainMessageEntity;
import cool.taomu.box.netty.mqtt.entity.MessageEntity;
import cool.taomu.box.netty.mqtt.utils.ISerializationUtils;
import cool.taomu.box.storage.inter.IStorage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttWillService {
    private static final Logger LOG = LoggerFactory.getLogger(MqttWillService.class);
    @Inject
    private IStorage storage;
    @Inject
    private ISerializationUtils isu;
    @Inject
    private MqttRetainMessageDao dao;

    public byte[] toBytes(MessageEntity s) {
        return this.isu.serialize(s);
    }

    public void store(MqttConnectMessage connectMessage, String clientId) {
        boolean _isWillFlag = connectMessage.variableHeader().isWillFlag();
        if (_isWillFlag) {
            LOG.info("\u4fdd\u5b58\u9057\u5631\u6d88\u606f \uff1a clientId:{}", (Object)clientId);
            MessageEntity will = new MessageEntity();
            will.setSenderId(clientId);
            will.setRetain(connectMessage.variableHeader().isWillRetain());
            will.setQos(connectMessage.variableHeader().willQos());
            will.setTopic(connectMessage.payload().willTopic());
            will.setPayload(connectMessage.payload().willMessageInBytes());
            this.saveWill(will);
        }
    }

    private void saveWill(MessageEntity will) {
        try {
            MqttRetainMessageEntity entity = new MqttRetainMessageEntity();
            entity.setUuid(UUID.randomUUID().toString());
            entity.setClientId(will.getSenderId());
            byte[] _payload = will.getPayload();
            String _string = new String(_payload, "UTF-8");
            entity.setMessage(_string);
            entity.setTopic(will.getTopic());
            entity.setWill("1");
            this.dao.insert(entity);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void push(String clientId) {
        LOG.info("Will\u672a\u5b9e\u73b0");
    }
}

