package cool.taomu.box.netty.mqtt;

import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.name.Names;
import cool.taomu.box.ioc.guice.TaomuGuiceModule;
import cool.taomu.box.netty.mqtt.inter.INettyMqtt;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@SuppressWarnings("all")
public class NettyMqttHandler extends ChannelInboundHandlerAdapter {
  private final Logger LOG = LoggerFactory.getLogger(NettyMqttHandler.class);
  
  private com.google.inject.Module module = new TaomuGuiceModule().build(NettMqttModule.class);
  
  @Override
  public void channelRead(final ChannelHandlerContext ctx, final Object obj) {
    final MqttMessage mqttMessage = ((MqttMessage) obj);
    if (((mqttMessage != null) && mqttMessage.decoderResult().isSuccess())) {
      MqttMessageType messageType = mqttMessage.fixedHeader().messageType();
      this.LOG.debug("收到请求类型：{}", messageType.name());
      INettyMqtt instance = Guice.createInjector(this.module).<INettyMqtt>getInstance(Key.<INettyMqtt>get(INettyMqtt.class, Names.named(messageType.name())));
      ((INettyMqtt) instance).request(ctx, mqttMessage);
    } else {
      ctx.close();
    }
  }
}
