package cool.taomu.box.netty.mqtt.dao;

import cool.taomu.box.netty.mqtt.dao.entity.MqttSubscribeEntity;
import java.util.List;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
@SuppressWarnings("all")
public interface MqttSubscribeDao {
  @Insert("insert into mqtt_subscribe(uuid,clientid,topic,qos) values(#{uuid},#{clientid},#{topic},#{qos})")
  int insert(@Param("uuid") final String uuid, @Param("clientid") final String clientid, @Param("topic") final String topic, @Param("qos") final int qos);
  
  @Select("select * from mqtt_subscribe")
  List<MqttSubscribeEntity> selectAll();
  
  @Select("select * from mqtt_subscribe where topic=#{topicName}")
  List<MqttSubscribeEntity> selectByTopic(final String topicName);
  
  @Select("select * from mqtt_subscribe where clientid=#{clientId}")
  List<MqttSubscribeEntity> selectByClientId(final String clientId);
}
