package cool.taomu.box.netty.mqtt.service;

import cool.taomu.box.netty.mqtt.dao.MqttSubscribeDao;
import cool.taomu.box.netty.mqtt.dao.entity.MqttSubscribeEntity;
import cool.taomu.box.netty.mqtt.entity.TopicEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class MqttSubscribeService {
  @Inject
  private MqttSubscribeDao dao;
  
  public void add(final TopicEntity entity) {
    String uuid = UUID.randomUUID().toString();
    this.dao.insert(uuid, entity.getClientId(), entity.getName(), entity.getQos());
  }
  
  public ArrayList<TopicEntity> get() {
    List<MqttSubscribeEntity> list = this.dao.selectAll();
    final ArrayList<TopicEntity> topicEntitys = new ArrayList<TopicEntity>();
    final Consumer<MqttSubscribeEntity> _function = (MqttSubscribeEntity it) -> {
      String _topic = it.getTopic();
      TopicEntity entity = new TopicEntity(_topic);
      entity.setClientId(it.getClientId());
      entity.setQos(it.getQos());
      topicEntitys.add(entity);
    };
    IterableExtensions.<MqttSubscribeEntity>filterNull(list).forEach(_function);
    return topicEntitys;
  }
}
