/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty;

import cool.taomu.box.netty.inter.IServerConfigure;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer {
    private final Logger LOG = LoggerFactory.getLogger(NettyServer.class);
    @Inject
    @Named(value="taomubox.mqtt.server.host")
    private String host;
    @Inject
    @Named(value="taomubox.mqtt.server.port")
    private int port;
    @Inject
    private IServerConfigure config;

    public void start() {
        try {
            int coreNumber = Runtime.getRuntime().availableProcessors();
            final NioEventLoopGroup selectGroup = new NioEventLoopGroup(coreNumber);
            final NioEventLoopGroup ioGroup = new NioEventLoopGroup(coreNumber * 2);
            Runtime _runtime = Runtime.getRuntime();
            _runtime.addShutdownHook(new Thread(){

                @Override
                public void run() {
                    selectGroup.shutdownGracefully();
                    ioGroup.shutdownGracefully();
                }
            });
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ServerBootstrap bootstrap = serverBootstrap.group((EventLoopGroup)selectGroup, (EventLoopGroup)ioGroup);
            bootstrap = (ServerBootstrap)bootstrap.channel(NioServerSocketChannel.class);
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
            this.config.bootstrap(bootstrap);
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    NettyServer.this.config.pipeline(ch.pipeline(), ch);
                }
            });
            this.LOG.info("bind host {} port {}", (Object)this.host, (Object)this.port);
            bootstrap.bind(this.host, this.port).sync();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

