/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.handler;

import com.google.inject.name.Named;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class MQTTSslHandler {
    public static SslHandler build(SocketChannel channel, SslConfigEntity config) {
        try {
            SslConfigEntity sslConfig = config;
            SslUtil ssl = new SslUtil(sslConfig.keyStoreType);
            KeyManagerFactory kmf = ssl.keyManageFactory(sslConfig.keyFilePath, sslConfig.managerPwd, sslConfig.storePwd);
            SslContextBuilder contextBuilder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
            SslContext sslContext = contextBuilder.sslProvider(SslProvider.valueOf((String)"JDK")).build();
            SSLEngine sslEngine = sslContext.newEngine(channel.alloc(), channel.remoteAddress().getHostString(), channel.remoteAddress().getPort());
            sslEngine.setUseClientMode(false);
            if (sslConfig.useClientCA) {
                contextBuilder.clientAuth(ClientAuth.REQUIRE);
                contextBuilder.trustManager(ssl.trustManageFactory());
                sslEngine.setNeedClientAuth(true);
            }
            return new SslHandler(sslEngine);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Accessors
    @ToString
    public static class SslConfigEntity {
        @Inject
        @Named(value="useClientCa")
        private boolean useClientCA;
        @Inject
        @Named(value="keyStoreType")
        private String keyStoreType;
        @Inject
        @Named(value="keyFilePath")
        private String keyFilePath;
        @Inject
        @Named(value="managerPwd")
        private String managerPwd;
        @Inject
        @Named(value="storePwd")
        private String storePwd;

        @Pure
        public boolean isUseClientCA() {
            return this.useClientCA;
        }

        public void setUseClientCA(boolean useClientCA) {
            this.useClientCA = useClientCA;
        }

        @Pure
        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public void setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        @Pure
        public String getKeyFilePath() {
            return this.keyFilePath;
        }

        public void setKeyFilePath(String keyFilePath) {
            this.keyFilePath = keyFilePath;
        }

        @Pure
        public String getManagerPwd() {
            return this.managerPwd;
        }

        public void setManagerPwd(String managerPwd) {
            this.managerPwd = managerPwd;
        }

        @Pure
        public String getStorePwd() {
            return this.storePwd;
        }

        public void setStorePwd(String storePwd) {
            this.storePwd = storePwd;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("useClientCA", (Object)this.useClientCA);
            b.add("keyStoreType", (Object)this.keyStoreType);
            b.add("keyFilePath", (Object)this.keyFilePath);
            b.add("managerPwd", (Object)this.managerPwd);
            b.add("storePwd", (Object)this.storePwd);
            return b.toString();
        }
    }

    public static class SslUtil {
        private KeyStore keyStore;

        public SslUtil(String keyStoreType) {
            try {
                String _xifexpression = null;
                _xifexpression = keyStoreType == null ? "JKS" : keyStoreType;
                this.keyStore = KeyStore.getInstance(_xifexpression);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public TrustManagerFactory trustManageFactory() {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(this.keyStore);
                return tmf;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public TrustManagerFactory trustManageFactory(String sslKeyFilePath, String sslStorePwd) {
            try {
                FileInputStream _fileInputStream = new FileInputStream(sslKeyFilePath);
                this.keyStore.load(_fileInputStream, sslStorePwd.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                tmf.init(this.keyStore);
                return tmf;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }

        public KeyManagerFactory keyManageFactory(String sslKeyFilePath, String sslManagerPwd, String sslStorePwd) {
            try {
                FileInputStream _fileInputStream = new FileInputStream(sslKeyFilePath);
                this.keyStore.load(_fileInputStream, sslStorePwd.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(this.keyStore, sslManagerPwd.toCharArray());
                return kmf;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }

        public SSLSocketFactory getSslSocketFactory() {
            try {
                List trustManagers;
                SSLContext sslContext = SSLContext.getInstance("TLS");
                List _converted_trustManagers = trustManagers = Collections.unmodifiableList(CollectionLiterals.newArrayList());
                SecureRandom _secureRandom = new SecureRandom();
                sslContext.init(null, (TrustManager[])Conversions.unwrapArray(_converted_trustManagers, TrustManager.class), _secureRandom);
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }
}

