/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty.pipline;

import cool.taomu.box.netty.inter.IServerConfigure;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.List;
import javax.inject.Inject;

public class MqttWebSocketConfigure
implements IServerConfigure {
    @Inject
    private ChannelInboundHandler handler;

    @Override
    public void bootstrap(ServerBootstrap channel) {
        ((ServerBootstrap)((ServerBootstrap)channel.option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.TCP_NODELAY, (Object)false).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
        ((ServerBootstrap)((ServerBootstrap)channel.option(ChannelOption.SO_RCVBUF, (Object)0)).option(ChannelOption.SO_REUSEADDR, (Object)false)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
    }

    @Override
    public void pipeline(ChannelPipeline pipeline, SocketChannel ch) {
        IdleStateHandler _idleStateHandler = new IdleStateHandler(0, 0, 60);
        pipeline.addLast("idleStateHandler", (ChannelHandler)_idleStateHandler);
        HttpServerCodec _httpServerCodec = new HttpServerCodec();
        pipeline.addLast("httpCodec", (ChannelHandler)_httpServerCodec);
        HttpObjectAggregator _httpObjectAggregator = new HttpObjectAggregator(65535);
        pipeline.addLast("aggregator", (ChannelHandler)_httpObjectAggregator);
        HttpContentCompressor _httpContentCompressor = new HttpContentCompressor();
        pipeline.addLast("compressor ", (ChannelHandler)_httpContentCompressor);
        WebSocketServerProtocolHandler _webSocketServerProtocolHandler = new WebSocketServerProtocolHandler("/mqtt", "mqtt,mqtt3.1,mqttv3.1.1", false, 65536);
        pipeline.addLast("webSocketHandler", (ChannelHandler)_webSocketServerProtocolHandler);
        pipeline.addLast("webSocket2ByteBufDecoder", (ChannelHandler)new MessageToMessageDecoder<BinaryWebSocketFrame>(){

            protected void decode(ChannelHandlerContext channelHandlerContext, BinaryWebSocketFrame binaryWebSocketFrame, List<Object> list) throws Exception {
                ByteBuf byteBuf = binaryWebSocketFrame.content();
                byteBuf.retain();
                list.add(byteBuf);
            }
        });
        pipeline.addLast("byteBuf2WebSocketEncoder", (ChannelHandler)new MessageToMessageDecoder<BinaryWebSocketFrame>(){

            protected void decode(ChannelHandlerContext channelHandlerContext, BinaryWebSocketFrame binaryWebSocketFrame, List<Object> list) throws Exception {
                ByteBuf byteBuf = binaryWebSocketFrame.content();
                byteBuf.retain();
                list.add(byteBuf);
            }
        });
        pipeline.addLast("mqttEncoder", (ChannelHandler)MqttEncoder.INSTANCE);
        MqttDecoder _mqttDecoder = new MqttDecoder(Integer.MAX_VALUE);
        pipeline.addLast("mqttDecoder", (ChannelHandler)_mqttDecoder);
        pipeline.addLast("nettyMqttHandler", (ChannelHandler)this.handler);
    }
}

