package cool.taomu.box.netty.pipline;

import cool.taomu.box.netty.inter.IServerConfigure;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.List;
import javax.inject.Inject;

@SuppressWarnings("all")
public class MqttWebSocketConfigure implements IServerConfigure {
  @Inject
  private ChannelInboundHandler handler;
  
  @Override
  public void bootstrap(final ServerBootstrap channel) {
    channel.<Integer>option(ChannelOption.SO_BACKLOG, Integer.valueOf(1024)).<Boolean>childOption(ChannelOption.TCP_NODELAY, Boolean.valueOf(false)).<Boolean>option(
      ChannelOption.SO_REUSEADDR, Boolean.valueOf(true)).<Boolean>childOption(ChannelOption.SO_KEEPALIVE, Boolean.valueOf(false));
    channel.<Integer>option(ChannelOption.SO_RCVBUF, Integer.valueOf(0)).<Boolean>option(ChannelOption.SO_REUSEADDR, Boolean.valueOf(false)).<Boolean>childOption(
      ChannelOption.SO_KEEPALIVE, Boolean.valueOf(false));
  }
  
  @Override
  public void pipeline(final ChannelPipeline pipeline, final SocketChannel ch) {
    IdleStateHandler _idleStateHandler = new IdleStateHandler(0, 0, 60);
    pipeline.addLast("idleStateHandler", _idleStateHandler);
    HttpServerCodec _httpServerCodec = new HttpServerCodec();
    pipeline.addLast("httpCodec", _httpServerCodec);
    HttpObjectAggregator _httpObjectAggregator = new HttpObjectAggregator(65535);
    pipeline.addLast("aggregator", _httpObjectAggregator);
    HttpContentCompressor _httpContentCompressor = new HttpContentCompressor();
    pipeline.addLast("compressor ", _httpContentCompressor);
    WebSocketServerProtocolHandler _webSocketServerProtocolHandler = new WebSocketServerProtocolHandler("/mqtt", "mqtt,mqtt3.1,mqttv3.1.1", false, 65536);
    pipeline.addLast("webSocketHandler", _webSocketServerProtocolHandler);
    pipeline.addLast(
      "webSocket2ByteBufDecoder", 
      new MessageToMessageDecoder<BinaryWebSocketFrame>() {
        @Override
        protected void decode(final ChannelHandlerContext channelHandlerContext, final BinaryWebSocketFrame binaryWebSocketFrame, final List<Object> list) throws Exception {
          ByteBuf byteBuf = binaryWebSocketFrame.content();
          byteBuf.retain();
          list.add(byteBuf);
        }
      });
    pipeline.addLast(
      "byteBuf2WebSocketEncoder", 
      new MessageToMessageDecoder<BinaryWebSocketFrame>() {
        @Override
        protected void decode(final ChannelHandlerContext channelHandlerContext, final BinaryWebSocketFrame binaryWebSocketFrame, final List<Object> list) throws Exception {
          ByteBuf byteBuf = binaryWebSocketFrame.content();
          byteBuf.retain();
          list.add(byteBuf);
        }
      });
    pipeline.addLast("mqttEncoder", MqttEncoder.INSTANCE);
    MqttDecoder _mqttDecoder = new MqttDecoder(Integer.MAX_VALUE);
    pipeline.addLast("mqttDecoder", _mqttDecoder);
    pipeline.addLast("nettyMqttHandler", this.handler);
  }
}
