/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.netty;

import cool.taomu.box.netty.inter.IClientConfigure;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class NettyClient {
    @Inject
    @Named(value="host")
    private String host;
    @Inject
    @Named(value="port")
    private int port;

    @Inject
    public void client(final IClientConfigure config) {
        try {
            int coreNumber = Runtime.getRuntime().availableProcessors();
            NioEventLoopGroup group = new NioEventLoopGroup(coreNumber);
            Bootstrap bootstrap = (Bootstrap)new Bootstrap().group((EventLoopGroup)group);
            config.bootstrap(bootstrap);
            Bootstrap _channel = (Bootstrap)bootstrap.channel(NioSocketChannel.class);
            _channel.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    config.pipeline(ch.pipeline(), ch);
                }
            });
            ChannelFuture cf = bootstrap.connect(this.host, this.port).sync();
            config.channel(cf.channel());
            cf.channel().closeFuture().sync();
            group.shutdownGracefully();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

