package cool.taomu.box.netty.handler;

import com.google.inject.name.Named;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SuppressWarnings("all")
public class MQTTSslHandler {
  public static class SslUtil {
    private KeyStore keyStore;
    
    public SslUtil(final String keyStoreType) {
      try {
        String _xifexpression = null;
        if ((keyStoreType == null)) {
          _xifexpression = "JKS";
        } else {
          _xifexpression = keyStoreType;
        }
        this.keyStore = KeyStore.getInstance(_xifexpression);
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
    
    public TrustManagerFactory trustManageFactory() {
      try {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.keyStore);
        return tmf;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
    
    public TrustManagerFactory trustManageFactory(final String sslKeyFilePath, final String sslStorePwd) {
      try {
        FileInputStream _fileInputStream = new FileInputStream(sslKeyFilePath);
        this.keyStore.load(_fileInputStream, sslStorePwd.toCharArray());
        final TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(this.keyStore);
        return tmf;
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          return null;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    
    public KeyManagerFactory keyManageFactory(final String sslKeyFilePath, final String sslManagerPwd, final String sslStorePwd) {
      try {
        FileInputStream _fileInputStream = new FileInputStream(sslKeyFilePath);
        this.keyStore.load(_fileInputStream, sslStorePwd.toCharArray());
        final KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(this.keyStore, sslManagerPwd.toCharArray());
        return kmf;
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          return null;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    
    public SSLSocketFactory getSslSocketFactory() {
      try {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        List<TrustManager> trustManagers = Collections.<TrustManager>unmodifiableList(CollectionLiterals.<TrustManager>newArrayList());
        final List<TrustManager> _converted_trustManagers = (List<TrustManager>)trustManagers;
        SecureRandom _secureRandom = new SecureRandom();
        sslContext.init(null, ((TrustManager[])Conversions.unwrapArray(_converted_trustManagers, TrustManager.class)), _secureRandom);
        return null;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }
  
  @Accessors
  @ToString
  public static class SslConfigEntity {
    @Inject
    @Named("useClientCa")
    private boolean useClientCA;
    
    @Inject
    @Named("keyStoreType")
    private String keyStoreType;
    
    @Inject
    @Named("keyFilePath")
    private String keyFilePath;
    
    @Inject
    @Named("managerPwd")
    private String managerPwd;
    
    @Inject
    @Named("storePwd")
    private String storePwd;
    
    @Pure
    public boolean isUseClientCA() {
      return this.useClientCA;
    }
    
    public void setUseClientCA(final boolean useClientCA) {
      this.useClientCA = useClientCA;
    }
    
    @Pure
    public String getKeyStoreType() {
      return this.keyStoreType;
    }
    
    public void setKeyStoreType(final String keyStoreType) {
      this.keyStoreType = keyStoreType;
    }
    
    @Pure
    public String getKeyFilePath() {
      return this.keyFilePath;
    }
    
    public void setKeyFilePath(final String keyFilePath) {
      this.keyFilePath = keyFilePath;
    }
    
    @Pure
    public String getManagerPwd() {
      return this.managerPwd;
    }
    
    public void setManagerPwd(final String managerPwd) {
      this.managerPwd = managerPwd;
    }
    
    @Pure
    public String getStorePwd() {
      return this.storePwd;
    }
    
    public void setStorePwd(final String storePwd) {
      this.storePwd = storePwd;
    }
    
    @Override
    @Pure
    public String toString() {
      ToStringBuilder b = new ToStringBuilder(this);
      b.add("useClientCA", this.useClientCA);
      b.add("keyStoreType", this.keyStoreType);
      b.add("keyFilePath", this.keyFilePath);
      b.add("managerPwd", this.managerPwd);
      b.add("storePwd", this.storePwd);
      return b.toString();
    }
  }
  
  public static SslHandler build(final SocketChannel channel, final MQTTSslHandler.SslConfigEntity config) {
    try {
      MQTTSslHandler.SslConfigEntity sslConfig = config;
      MQTTSslHandler.SslUtil ssl = new MQTTSslHandler.SslUtil(sslConfig.keyStoreType);
      KeyManagerFactory kmf = ssl.keyManageFactory(sslConfig.keyFilePath, sslConfig.managerPwd, sslConfig.storePwd);
      SslContextBuilder contextBuilder = SslContextBuilder.forServer(kmf);
      SslContext sslContext = contextBuilder.sslProvider(SslProvider.valueOf("JDK")).build();
      SSLEngine sslEngine = sslContext.newEngine(channel.alloc(), channel.remoteAddress().getHostString(), 
        channel.remoteAddress().getPort());
      sslEngine.setUseClientMode(false);
      if (sslConfig.useClientCA) {
        contextBuilder.clientAuth(ClientAuth.REQUIRE);
        contextBuilder.trustManager(ssl.trustManageFactory());
        sslEngine.setNeedClientAuth(true);
      }
      return new SslHandler(sslEngine);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
