package cool.taomu.box.netty.pipline;

import cool.taomu.box.netty.handler.MQTTSslHandler;
import cool.taomu.box.netty.inter.IServerConfigure;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import javax.inject.Inject;

@SuppressWarnings("all")
public class MqttSSLConfigure implements IServerConfigure {
  @Inject
  private ChannelInboundHandler handler;
  
  @Inject
  private MQTTSslHandler.SslConfigEntity config;
  
  @Override
  public void bootstrap(final ServerBootstrap channel) {
    channel.<Integer>option(ChannelOption.SO_BACKLOG, Integer.valueOf(1024)).<Boolean>childOption(ChannelOption.TCP_NODELAY, Boolean.valueOf(false)).<Boolean>option(
      ChannelOption.SO_REUSEADDR, Boolean.valueOf(true)).<Boolean>childOption(ChannelOption.SO_KEEPALIVE, Boolean.valueOf(false));
  }
  
  @Override
  public void pipeline(final ChannelPipeline pipeline, final SocketChannel ch) {
    pipeline.addLast("ssl", MQTTSslHandler.build(ch, this.config));
    IdleStateHandler _idleStateHandler = new IdleStateHandler(60, 0, 0);
    pipeline.addLast("idleStateHandler", _idleStateHandler);
    pipeline.addLast("mqttEncoder", MqttEncoder.INSTANCE);
    MqttDecoder _mqttDecoder = new MqttDecoder(Integer.MAX_VALUE);
    pipeline.addLast("mqttDecoder", _mqttDecoder);
    pipeline.addLast("nettyMqttHandler", this.handler);
  }
}
