/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.oltu.service;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.oltu.oauth2.as.issuer.MD5Generator;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.issuer.ValueGenerator;
import org.apache.oltu.oauth2.as.request.OAuthAuthzRequest;
import org.apache.oltu.oauth2.as.request.OAuthTokenRequest;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ServerService {
    public String OwnerCode(HttpServletRequest request, ICode code) {
        try {
            String result = "";
            OAuthAuthzRequest req = new OAuthAuthzRequest(request);
            boolean _isNotEmpty = StringUtils.isNotEmpty((CharSequence)req.getClientId());
            if (_isNotEmpty) {
                String id = req.getClientId();
                OAuthASResponse.OAuthAuthorizationResponseBuilder builder = OAuthASResponse.authorizationResponse((HttpServletRequest)request, (int)302);
                builder.setCode(code.getCode(id));
                String redirectURI = req.getParam("redirect_uri");
                OAuthResponse resp = builder.location(redirectURI).buildQueryMessage();
                result = resp.getLocationUri();
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String getToken(HttpServletRequest request, IToken token) {
        try {
            boolean _isNoneEmpty;
            String result = "{}";
            OAuthTokenRequest req = new OAuthTokenRequest(request);
            String clientId = req.getClientId();
            String clientSecret = req.getClientSecret();
            boolean _isCode = token.isCode(req.getCode(), clientId, clientSecret);
            if (_isCode && (_isNoneEmpty = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{clientId, clientSecret}))) {
                MD5Generator _mD5Generator = new MD5Generator();
                OAuthIssuerImpl issuer = new OAuthIssuerImpl((ValueGenerator)_mD5Generator);
                OAuthASResponse.OAuthTokenResponseBuilder resp = OAuthASResponse.tokenResponse((int)200);
                resp.setAccessToken(issuer.accessToken());
                resp.setRefreshToken(issuer.refreshToken());
                resp.setExpiresIn("1000");
                result = resp.buildJSONMessage().getBody();
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static interface IToken {
        public boolean isCode(String var1, String var2, String var3);
    }

    public static interface ICode {
        public String getCode(String var1);
    }
}

